# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Nathan Seal nathan@nathanseal.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import time
import wiimote
import virtualinput
import re
from mapper.mapper import Mapper
import math

class WiimoteHandler:
	"""
	class for mapping wiimote input to keyboard, mouse and joystick input.
	"""
	requiredMotes = ['1']
	wiiMotes = []
	tempMote = None
	numConnected = 0
	numberToConnect = 0
	vinput = None
	allConnectedCallback = None
	running = False
	def start(self, nummotes = 1, callback=None, messageHandler=None):
		print "press 1 and 2 to sync motes"
		self.stop()
		self.running = True
		self.numberToConnect = nummotes
		self.allConnectedCallback = callback
		self.statusCallback = messageHandler
		self.connectToMote()
	
	def on_connect(self, mote, motenum):
	    if callable(self.statusCallback):
		    self.statusCallback("mote " + str(motenum + 1) + " synced")
		self.wiiMotes.append(mote)
		self.tempMote = None
		self.numConnected += 1
		mote.turn_led_on(motenum + 1)
		mote.onButtonDown = self.onButtonDown
		mote.onButtonUp = self.onButtonUp
		mote.onAccChange = self.onAccChange
		mote.onIRChange = self.onIRChange
		mote.id = motenum
		if self.numConnected < self.numberToConnect:
			self.connectToMote()
		elif callable(self.allConnectedCallback):
			self.allConnectedCallback()
			
	
	def on_fail_connect(self, mote, motenum):
		self.stop()
	
	def connectToMote(self):
	    if len(self.requiredMotes) > 0:
	        moteid = int(self.requiredMotes.pop(0)) - 1
		    self.tempMote = wiimote.Wiimote(self.on_connect, self.on_fail_connect, self.statusCallback, (moteid,))
	
	def is_running(self):
		return self.running
	
	def stop(self):
		for mote in self.wiiMotes:
			mote.close()
		if self.tempMote != None:
		    self.tempMote.close()
		self.wiiMotes = []
		self.running = False
	
	def onButtonDown(self, *args):
		pass
	def onButtonUp(self, *args):
		pass
	def onAccChange(self, *args):
		pass
	def onIRChange(self, *args):
		pass
	

if __name__ == "__main__":
	wmh = WiimoteHandler()
	wmh.start(2)
	while True:
		time.sleep(10)
	wmh.stop()
