# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Nathan Seal nathan@nathanseal.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import cwiid
#from cwiid import *
import threading
import math

def buttonNumber_to_buttonString(button):
	string = None
	if button == cwiid.BTN_A:
		string = 'BTN_A'
	elif button == cwiid.BTN_B:
		string = 'BTN_B'
	elif button == cwiid.BTN_UP:
		string = 'BTN_UP'
	elif button == cwiid.BTN_DOWN:
		string = 'BTN_DOWN'
	elif button == cwiid.BTN_LEFT:
		string = 'BTN_LEFT'
	elif button == cwiid.BTN_RIGHT:
		string = 'BTN_RIGHT'
	elif button == cwiid.BTN_MINUS:
		string = 'BTN_MINUS'
	elif button == cwiid.BTN_PLUS:
		string = 'BTN_PLUS'
	elif button == cwiid.BTN_HOME:
		string = 'BTN_HOME'
	elif button == cwiid.BTN_1:
		string = 'BTN_1'
	elif button == cwiid.BTN_2:
		string = 'BTN_2'
	return string
def fromString_to_buttonString(button):
	string = None
	button = button.lower().strip()
	if button in ('a', 'btn_a'):
		string = 'BTN_A'
	elif button in ('b', 'btn_b'):
		string = 'BTN_B'
	elif button in ('up', 'btn_up', 'u'):
		string = 'BTN_UP'
	elif button in ('down', 'btn_down', 'd'):
		string = 'BTN_DOWN'
	elif button in ('left', 'btn_lwft', 'l'):
		string = 'BTN_LEFT'
	elif button in ('right', 'btn_right', 'r'):
		string = 'BTN_RIGHT'
	elif button in ('minus', 'btn_minus', 'm'):
		string = 'BTN_MINUS'
	elif button in ('plus', 'btn_plus', 'p'):
		string = 'BTN_PLUS'
	elif button in ('home', 'btn_home', 'h'):
		string = 'BTN_HOME'
	elif button in ('1', 'btn_1', 'one', 'o'):
		string = 'BTN_1'
	elif button in ('2', 'btn_2', 'two', 't'):
		string = 'BTN_2'
	return string

class Wiimote(cwiid.Wiimote):
	on_event = None
	ledState = 0
	connectThread = None
	
	btn_state = 0
	onButtonDown = None
	onButtonUp = None
	onAccChange = None
	onIRChange = None
	
	connectThread = None
	stopFlag = False
	connected = False
	def __init__(self, callback = None, callbackFail = None, messageCallback = None, args = ()):
	    self.id = -1
	    self.callback = callback
	    self.callbackFail = callbackFail
	    self.messageCallback = messageCallback
	    self.args = args
		self.connectThread = threading.Thread(target=self.connect)
		self.connectThread.start()
	
	def connect(self):
	    countTimes = 0
	    done = False
	    if callable(self.messageCallback):
	        self.messageCallback("Connecting... (press 1 + 2)")
	    while not done and countTimes < 3:
	        if self.stopFlag:
	            return None
	        try:
        		super(Wiimote, self).__init__()
        		self.connected = True
        		done = True
            except RuntimeError:
                if callable(self.messageCallback):
                    self.messageCallback("error connecting to wiimote. trying again " + str(countTimes + 1))
                countTimes += 1
        if self.stopFlag:
	        return None
        if done:
		    self.enable(cwiid.FLAG_MESG_IFC)
		    self.rpt_mode = cwiid.RPT_BTN | cwiid.RPT_ACC | cwiid.RPT_IR
		    self.mesg_callback = self.mesg_handler
		    if callable(self.callback):
			    self.callback(self, *self.args)
	    elif callable(self.callbackFail):
	        self.messageCallback("Failed to connect to wiimote")
			self.callbackFail(self, *self.args)
	
	def close(self):
	    if self.connectThread.isAlive():
	        self.stopFlag = True
	        self.connectThread.join()
	    if self.connected:
	        super(Wiimote, self).close()
	        self.connected = False
	
	def mesg_handler(self, messages, time):
		for message in messages:
			self.handle_message(message, time)
	
	def handle_message(self, message, time):
		messageType = message[0]
		messageDetail = message[1]
		if messageType == cwiid.MESG_BTN:
			oldButtonState = self.btn_state
			self.btn_state = messageDetail
			for i in range(32):
				old = oldButtonState >> i & 1
				new = self.btn_state >> i & 1
				if not old and new and callable(self.onButtonDown):
					self.onButtonDown(self.id, 2 ** i)
				elif old and not new and callable(self.onButtonUp):
					self.onButtonUp(self.id, 2 ** i)
		elif messageType == cwiid.MESG_ACC:
			if callable(self.onAccChange):
			    cal = self.get_acc_cal(cwiid.EXT_NONE)
				xac = (messageDetail[0] - cal[0][0]) / 255.0 * 200
				yac = (messageDetail[1] - cal[0][1]) / 255.0 * 200
				zac = (messageDetail[2] - cal[0][2]) / 255.0 * 200
		        acc = (abs(xac) + abs(yac) + abs(zac)) / 3.0
		        yax = math.atan2(xac, zac) * (180/math.pi) % 360
		        xax = math.atan2(-yac, zac) * (180/math.pi) % 360
		        zax = math.atan2(xac, yac) * (180/math.pi) % 360
				self.onAccChange(self.id, acc, xac, yac, zac, xax, yax, zax)
				print '{0:1d} {1:5d} {2:5d} {3:5d} {4:5d} {5:5d} {6:5d} # {7:5d} {8:5d} {9:5d}'.format(int(acc), int(xac), int(yac), int(zac), int(xax), int(yax), int(zax), messageDetail[0], messageDetail[1], messageDetail[2]), `self.get_acc_cal(cwiid.EXT_NONE)`
				#print `self.get_acc_cal()`
		elif messageType == cwiid.MESG_IR:
		    if callable(self.onIRChange):
		        x = 0
		        y = 0
		        count = 0
		        for part in messageDetail:
		            if part != None:
		                tx, ty = part['pos']
		                tx *= part['size']
		                ty *= part['size']
		                count += part['size']
		                x += tx
		                y += ty
		        if count > 0:
		            x /= count
		            y /= count
		            x /= 10.24
		            y /= 10.24
		            self.onIRChange(self.id, x, y)
			
	
		
	def turn_led_on(self, ledNum):
		current = self.ledState >> (ledNum - 1) & 1
		if not current:
			self.ledState ^= 2 ** (ledNum - 1)
			self.led = self.ledState
	
	def turn_led_off(self, ledNum):
		current = ledState >> (ledNum - 1) & 1
		if current:
			self.ledState ^= 2 ** (ledNum - 1)
			self.led = self.ledState
	
	def ledon(self, ledNum, on = True):
		current = ledState >> (ledNum - 1) & 1
		if on and current:
			self.ledState ^= 2 ** (ledNum - 1)
			self.led = self.ledState
		elif not current:
			self.ledState ^= 2 ** (ledNum - 1)
			self.led = self.ledState
