# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Nathan Seal nathan@nathanseal.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE


class Mapper:
	"""
	used to map inputs to callable functions
	"""
	def __init__(self):
	    self.mappings = {}
	    self.sameMap = {}
	def setSame(self, froom, to):
		"""
		set 'froom' to be the same as 'to'
		make getMapping(froom) => getMapping(to)
		"""
		froom = self.niceInput(froom)
		to = self.niceInput(to)
		self.sameMap[froom] = to
	def niceInput(self, value):
		value = value.lower().strip()
		while value in self.sameMap:
			value = self.sameMap[value]
		return value
	
	def addMapping(self, froom, to):
		froom = self.niceInput(froom)
		if froom not in self.mappings:
			self.mappings[froom] = []
		self.mappings[froom].append(to)
	
	def setMapping(self, froom, to):
		froom = self.niceInput(froom)
		self.mappings[froom] = to
	
    def clearMapping(self, froom):
        froom = self.niceInput(froom)
        if froom in self.mappings:
            print "########"
            print "clear mapping"
            print "########"
		    self.mappings.pop(froom, None)

	def clearMappings(self):
		self.mappings = {}
	
	def getMapping(self, froom):
		froom = self.niceInput(froom)
		result = []
		if froom in self.mappings:
			result = self.mappings[froom]
		return result
