import Xlib
import Xlib.display
import Xlib.XK
import Xlib.X

display = Xlib.display.Display()
screen = display.screen()
root = screen.root
	
def keysym_to_string(keysym):
	for attr in dir(Xlib.XK):
		val = Xlib.XK.__getattribute__(attr)
		if attr[:3] == 'XK_' and val == keysym:
			return attr[3:]

def keycode_to_string(keycode):
	global root, display, screen
	print "keycode", keycode
	keysym = display.keycode_to_keysym(keycode, 0)
	print "keysym", keysym
	string = keysym_to_string(keysym)
	return string

def grabKey():
	global root, display, screen
	root.grab_keyboard(False, Xlib.X.GrabModeAsync, Xlib.X.GrabModeAsync, Xlib.X.CurrentTime)
	done = False
	event = None
	while not done:
		event = display.next_event()
		if isinstance(event, Xlib.protocol.event.KeyPress):
			done = True
	display.ungrab_keyboard(Xlib.X.CurrentTime)
	display.flush()
	print Xlib.X.CurrentTime, 'ungrab'
	return keycode_to_string(event.detail)

if __name__ == '__main__':
	print `grabKey()`
	print Xlib.XK.string_to_keysym('XK_Control_R')
