#!/usr/bin/python

#    Copyright (C) 2011  Stefano Palazzo <stefano.palazzo@gmail.com>
#                  2011  Mark Tully <markjtully@gmail.com>

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.


from gi.repository import Gio

import urllib
import urllib2
import gzip
import cStringIO
import json
import functools
import time
import random

EVERYTHING = 0
SOLVED = 1
ANSWERED = 2
UNANSWERED = 3
TAGS = 4
USERS = 5
BADGES = 6

DEFAULT_SITE = "askubuntu.com"
SE_API_KEY = "BmtlCGm1UU-Cmn8FAvfT4Q"
BADGES = {}
ICONS = {}
NUMS = "0123456789"
SITES = (
    ("@au", DEFAULT_SITE, "Ask Ubuntu"),
    ("@so", "stackoverflow.com", ""),
    ("@su", "superuser.com", ""),
    ("@sf", "serverfault.com", ""),
    ("@stackoverflow", "stackoverflow.com", "Stack Overflow"), 
    ("@serverfault", "serverfault.com", "Server Fault"), 
    ("@superuser", "superuser.com", "Super User"), 
    ("@webapps", "webapps.stackexchange.com", "Web Applications"), 
    ("@gaming", "gaming.stackexchange.com", "Gaming"), 
    ("@webmasters", "webmasters.stackexchange.com", "Webmasters"), 
    ("@cooking", "cooking.stackexchange.com", "Cooking"), 
    ("@gamedev", "gamedev.stackexchange.com", "Game Development"), 
    ("@photo", "photo.stackexchange.com", "Photography"), 
    ("@stats", "stats.stackexchange.com", "Statistics"), 
    ("@math", "math.stackexchange.com", "Mathematics"), 
    ("@diy", "diy.stackexchange.com", "DIY"), 
    ("@gis", "gis.stackexchange.com", "GIS"), 
    ("@tex", "tex.stackexchange.com", "TeX - LaTeX"),  
    ("@money", "money.stackexchange.com", "Personal Finance and Money "), 
    ("@english", "english.stackexchange.com", "English Language & Usage"), 
    ("@stackapps", "stackapps.com", "Stack Apps"), 
    ("@ux", "ux.stackexchange.com", "User Experience"), 
    ("@unix", "unix.stackexchange.com", "Unix and Linux"), 
    ("@wordpress", "wordpress.stackexchange.com", "Wordpress"), 
    ("@cstheory", "cstheory.stackexchange.com", "Theoretical Computer Science"), 
    ("@apple", "apple.stackexchange.com", "Apple"), 
    ("@rpg", "rpg.stackexchange.com", "Role Playing Games"), 
    ("@bicycles", "bicycles.stackexchange.com", "Bicycles"), 
    ("@programmers", "programmers.stackexchange.com", "Programmers"), 
    ("@electronics", "electronics.stackexchange.com", "Electronics"), 
    ("@android", "android.stackexchange.com", "Android"), 
    ("@onstartups", "onstartups.stackexchange.com", "OnStartups"), 
    ("@boardgames", "boardgames.stackexchange.com", "Board & Card Games"), 
    ("@physics", "physics.stackexchange.com", "Physics"), 
    ("@homebrew", "homebrew.stackexchange.com", "Homebrew"), 
    ("@security", "security.stackexchange.com", "IT Security"), 
    ("@writers", "writers.stackexchange.com", "Writers"), 
    ("@audio", "audio.stackexchange.com", "Audio-Video Production"), 
    ("@graphicdesign", "graphicdesign.stackexchange.com", "Graphic Design"), 
    ("@dba", "dba.stackexchange.com", "Database Administration"), 
    ("@scifi", "scifi.stackexchange.com", "Science Fiction"), 
    ("@guitars", "guitars.stackexchange.com", "Guitars"), 
    ("@codereview", "codereview", "Code Review"), 
    ("@codegolf", "codegolf.stackexchange.com", "Code Golf"), 
    ("@quant", "quant.stackexchange.com", "Quantitative Finance"), 
    ("@pm", "pm.stackexchange.com", "Project Management"), 
    ("@skeptics", "skeptics.stackexchange.com", "Skeptics"), 
    ("@fitness", "fitness.stackexchange.com", "Fitness & Nutrition"), 
    ("@drupal", "drupal.stackexchange.com", "Drupal"), 
    ("@mechanics", "mechanics.stackexchange.com", "Motor Vehicle Maintenence"), 
    ("@parenting", "parenting.stackexchange.com", "Parenting"), 
    ("@sharepoint", "sharepoint.stackexchange.com", "Sharepoint"),
    ("@meta", "meta." + DEFAULT_SITE, "Ask Ubuntu Meta"),
)


def memoize_infinitely(function):
    """ Caches results of certain functions to improve performance
    """
    cache = {}
    @functools.wraps(function)
    def wrapped(*args):
        if not args in cache:
            cache[args] = function(*args)
        return cache[args]
    return wrapped

#@api_data_cache  # what happes if the user wants to find their new question?
def get_api_data(query, site=DEFAULT_SITE):
    """ Checks if askubuntu is being searched and if it is, decides which 
    askubuntu mirror to do the search on.  Also performs the search.
    Args:
      query: the search string
      site: the site to be searched
    Returns:
      A json object containing the search results
    """
    print "api.%s/\33[1;31m%s\33[m" % (site, query)
    if query.startswith("similar?title") and site == "askubuntu.com":
        try:
            # Check to see if we can ping the local data server running on
            # port 19115
            try:
                result = json.loads(urllib2.urlopen(
                    "http://localhost:19115/%s" % query.replace(" ", "%20"),
                    timeout=0.2).read())
                print "\33[1mused local service\33[m"
                return result
            except Exception as e:
                if random.random() > 0.5:
                    result = json.loads(urllib2.urlopen(
                        "http://50.19.108.78:8080/%s" % query.replace(" ", "%20"),
                        timeout=0.5).read())
                    print "\33[1mused ec2 service\33[m"
                else:
                    result = json.loads(urllib2.urlopen(
                        "http://audata.quickmediasolutions.com:8046/%s" % query.replace(" ", "%20"),
                        timeout=0.5).read())
                    print "\33[1mused AU Data Server service\33[m"
                return result
        except Exception as e:
            print "\33[1;31m%s\33[m" % repr(e)
    try:
        query = query.replace(" ", "%20")
        site = "api." + site if site != "stackauth.com" else site
        url = "http://%s/1.0/%s" % (site, query)
        url += ("&key=%s" if "?" in url else "?key=%s") % SE_API_KEY
        response = urllib.urlopen(url)
        print "API Calls:", ' / '.join(i.split()[1].strip() for i in
            str(response.headers).split("\n")[4:6][::-1])
        response = response.read()
        return json.load(gzip.GzipFile(fileobj=cStringIO.StringIO(response)))
    except IOError, e:
        print repr(e)
        return []


def detect_site(search):
    """ 
    Args:
      search: the search (contains the site and search string)
    Returns:
      The site and the search string
    """
    global BADGES
    site = DEFAULT_SITE
    for modifier, url, sitename in SITES:
        if search.startswith(modifier):
            search = search.replace(modifier, "").strip()
            site = url
            if site not in BADGES:  # get badges if the site has been called
                BADGES[site] = get_api_data("badges", url)  # the first time
    return site, search


@memoize_infinitely
def get_gravatar_url(email_hash):
    """ Gets a user's gravatar
    Args:
      email_hash: a hash of the user's email (obtained from the stackexchange result)
    Returns:
      A url pointing to the user's gravatar
    """
    url = "http://www.gravatar.com/avatar/%s?s=128&d=identicon&r=PG"
    return str(url % email_hash)


def get_questions(search):
    """ Gets questions matching the search from the relevant stackexchange site
    Args: 
      search: the search string
    Returns:
      url: the question's url 
      icon: the question's icon (based on the solved state of the question)
      title: the question's title
      text: The question's vote count and/or no of answers depending on its solved status
      category: The question's category (solved, answered or unanswered)
    """
    already_seen = []
    site, search = detect_site(search)
    search += " "  # Hack: Makes SE return questions for a single-word query
    data = get_api_data("similar?&pagesize=30&title=%s" % search, site)
    if data and "questions" in data:
        for i in data['questions']:
            # Filter out resuts marked as [Closed]
            if "closed_date" in i:
                continue
            if "question_id" in i and "title" in i:
                _id = i['question_id']
                if _id not in already_seen:
                    url = "http://%s/questions/%d" % (site, _id)
                    title = i['title']
                    if i['answer_count'] >= 1:
                        icon = Gio.ThemedIcon.new("help-browser").to_string()
                        category = ANSWERED
                        text = "%s votes, " % (i['up_vote_count'] - i['down_vote_count'])
                        text2 = "%s responses" % i["answer_count"]
                        text = text + text2
                    else:
                        icon = Gio.ThemedIcon.new("application-default-icon").to_string()
                        category = UNANSWERED
                        text = "%s votes" % (i['up_vote_count'] - i['down_vote_count'])
                    if "accepted_answer_id" in i:
                        icon = Gio.ThemedIcon.new("gtk-ok").to_string()
                        category = SOLVED
                        text = "%s votes" % (i['up_vote_count'] - i['down_vote_count'])
                    tags = "[" + ']   ['.join(i['tags'][:2]) + "]"
                    score = 0
                    if "up_vote_count" in i and "down_vote_count" in i:
                        score = "%+d" % (i['up_vote_count'] - i['down_vote_count'])
                    #text = ("(%s)  %s" % (score, tags)).strip()
                    #if "up_vote_count" in i and "favorite_count" in i:
                    #    if i['favorite_count'] or i['up_vote_count'] > 5:
                    #       title = u"\u2605 " + unicode(title)
                    yield url, icon, title, text, category
                    already_seen.append(_id)


@memoize_infinitely
def get_tags(search):
    """ Gets tags matching the search from the relevant stackexchange site
    Args: 
      search: the search string
    Returns:
      result: Contains the tag's url and title
    """
    site, search = detect_site(search)
    for search in search.split():  # this is _BA-AD_ for long searches
        if not all(i in NUMS for i in search):
            data = get_api_data(
                "tags?filter=%s&pagesize=10" % search, site)
            result = []
            if "tags" in data:
                for i in data['tags']:
                    url = "http://%s/tags/%s" % (site, i['name'])
                    result.append([url, i['name']])
            return result


@memoize_infinitely
def get_users(search):
    """ Gets users matching the search from the relevant stackexchange site
    Args: 
      search: the search string
    Returns:
      url: the result's url
      icon: the user's icon
      title: the user's name
    """
    site, search = detect_site(search)
    data = get_api_data(
        "users?filter=%s&pagesize=30&sort=reputation" % search, site)
    if "users" in data:
        for i in data['users']:
            url = "http://%s/users/%d" % (site, i['user_id'])
            title = i['display_name']
            icon = get_gravatar_url(i['email_hash'])
            yield url, icon, title


@memoize_infinitely
def get_badges(search):
    """ Gets badges matching the search from the relevant stackexchange site
    Args: 
      search: the search string
    Returns:
      result: the badges url and title
    """
    global BADGES
    site, search = detect_site(search)
    already_seen = []
    if not "askubuntu.com" in BADGES:
        BADGES["askubuntu.com"] = get_api_data("badges", "askubuntu.com")
    B = BADGES[site]
    for i in B['badges']:
        if any(x in i['name'].lower() for x in search.lower().split()):
            result = "http://%s/badges/%s" % (site, i['name']), i['name']
            if result not in already_seen:
                yield result
                already_seen.append(result)
