# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 David Pan <dalpivand@gmail.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import optparse

import gettext
from gettext import gettext as _
gettext.textdomain('unity-launcher-toggle')

from gi.repository import Gtk # pylint: disable=E0611

#from unity_launcher_toggle import UnityLauncherToggleWindow

from unity_launcher_toggle_lib import set_up_logging, get_version



from gi.repository import AppIndicator3 as appindicator
import gconf
from gi.repository import Gio



def parse_options():
    """Support for command line options"""
    parser = optparse.OptionParser(version="%%prog %s" % get_version())
    parser.add_option(
        "-v", "--verbose", action="count", dest="verbose",
        help=_("Show debug messages (-vv debugs unity_launcher_toggle_lib also)"))
    (options, args) = parser.parse_args()

    set_up_logging(options)

def main():
    #'constructor for your class instances'
    parse_options()

    # Run the application.    
    #window = IndicatorLauncherWindow.IndicatorLauncherWindow()
    #window.show()
    
    ind = appindicator.Indicator.new(
                        "unity-launcher-toggle",
                        "indicator-messages",
                        appindicator.IndicatorCategory.OTHER)
    ind.set_status(appindicator.IndicatorStatus.ACTIVE)
    #ind.set_attention_icon("indicator-messages-new")
    
    
    
    
    
    #print "yoyoyo "
    #print ind.get_icon_theme_path()
    
    
    
    
    
    #ind.set_icon_theme_path('/home/david/indicator-launcher/data/media')
    
    #ind.set_icon_theme_path('/usr/share/indicator-launcher/media')
    
 	ind.set_icon_theme_path('/opt/extras.ubuntu.com/unity-launcher-toggle/share/unity-launcher-toggle/media')
    
    
    
    #print ind.get_icon_theme_path()

 
 
 
 
 
 
 
 
    # create a menu
    menu = Gtk.Menu()
	
	
	
	
	
	
	
	
	
	
	
	
	#group = []
	
	#item0 = Gtk.RadioMenuItem("Fixed")
	#item0 = Gtk.RadioMenuItem.new_with_label(group, "Fixed")
	#item0.show()
	
	#group = item0.get_group()
	
	#item.connect("toggled", toggle_launcher, '0', ind)
    #menu.append(item0)
        
    #item1 = Gtk.RadioMenuItem("Hidden")
    #item1 = Gtk.RadioMenuItem.new_with_label(group, "Hidden")
    #item1.show()
		
    #item.connect("toggled", toggle_launcher, '1', ind)
    #menu.append(item1)
    
    #item0.connect("toggled", toggle_launcher, '0', ind)
    #item1.connect("toggled", toggle_launcher, '1', ind)
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    # set initial icon
    
    #client = gconf.client_get_default()
	#key = '/apps/compiz-1/plugins/unityshell/screen0/options/launcher_hide_mode'
	number = get_launcher_mode()
	
    if number == 0:
		#item0.set_active(True)
		if get_gtk_theme() == "Radiance":
            ind.set_icon('icon1')
        else:
            ind.set_icon('icon0')
    elif number == 1:
		#item1.set_active(True)
		if get_gtk_theme() == "Radiance":
            ind.set_icon('icon0')
        else:
            ind.set_icon('icon1')
		
		
		
		
		
		
		
	# add toggle item
	
	item = Gtk.MenuItem("Toggle")
    item.connect("activate", toggle_launcher, ind)
    item.show()
    menu.append(item)
    
    
    
    
    
    
    
    # add separator item
          
    sep = Gtk.SeparatorMenuItem()
    sep.show()
    menu.append(sep)
    
    
    
    
    
    
    # add about item
        
    item = Gtk.MenuItem("About")
    item.connect("activate", about_dialog)
    item.show()
    menu.append(item)
        
        
        
        
        
    # add quit item
        
    item = Gtk.MenuItem("Quit")
    item.connect("activate", quit)
    item.show()
    menu.append(item)
 
    ind.set_menu(menu)
    
    Gtk.main()














"""
def toggle_launcher(widget, data, ind):
    #if widget.active:	
    client = gconf.client_get_default()
    key = '/apps/compiz-1/plugins/unityshell/screen0/options/launcher_hide_mode'

    if data == '0':
        client.set_int(key, 0)
        ind.set_icon('icon0')
        #item1.set_active(False)
    elif data == '1':
        client.set_int(key, 1)
        ind.set_icon('icon1')
        #item0.set_active(False)
"""









def toggle_launcher(widget, ind):	
    print "toggling........."
    
    num = get_launcher_mode()
    
    print num
    
    if num == 0:
        set_launcher_mode(1)
        
        theme = get_gtk_theme()
        
        if theme == "Radiance":
            ind.set_icon('icon0')
        else:
            ind.set_icon('icon1')
        
        print "0"
        #item1.set_active(False)
    elif num == 1:
        set_launcher_mode(0)
        
        theme = get_gtk_theme()
        
        if get_gtk_theme() == "Radiance":
            ind.set_icon('icon1')
        else:
            ind.set_icon('icon0')
            
        print "1"
        #item0.set_active(False)
    else:
        print "asdfadf asd fadfasdf"






def get_launcher_mode():
    client = gconf.client_get_default()
    key = '/apps/compiz-1/plugins/unityshell/screen0/options/launcher_hide_mode'
    number = client.get_int(key)
    
    return number

def get_gtk_theme():
    theme = Gio.Settings.new('org.gnome.desktop.interface').get_string('gtk-theme')
    return theme  


def set_launcher_mode(num):
    client = gconf.client_get_default()
    key = '/apps/compiz-1/plugins/unityshell/screen0/options/launcher_hide_mode'
    
    #num = int(num)
    
    client.set_int(key, num)
    
    print "set"
    print num
        







def about_dialog(widget):
    dialog = AboutAboutDialog()
    dialog.run()
    dialog.destroy()
	
class AboutAboutDialog(Gtk.AboutDialog):
	def __init__(self):
		Gtk.AboutDialog.__init__(self)
		self.set_program_name("Unity Launcher Toggle")
		self.set_copyright("Copyright 2012 David Pan")
		self.set_comments("Add the following command to Startup Applications: \n /opt/extras.ubuntu.com/unity-launcher-toggle/bin/unity-launcher-toggle")
		self.set_website('http://napdivad.com/unity_launcher_toggle/')
		self.set_website_label('Website')
		
		
		
