#!/usr/bin/python

from xml.dom.minidom import Document
from time import gmtime, strftime
import os

# This file is responsible for 
## 	- appending a bookmark to xml file
##	- counting the time a bookmark is used
##	- removing a bookmark based on its name
## 	- alter a bookmark

# NEDERLANDS
	# TOEVOEGEN
	# TELLEN
	# VERWIJDEREN?
	# SORTEREN?
	# ...

# TODO	
	# TODO replace strings by param in add bookmark
	# TODO order after add count
	

### <?xml version="1.0" encoding="UTF-8" ?>
### <bookmarks>
### 	<bookmark name='' count=''>
### 		<url>http://www.sporza.be</url>
### 		<timestamp>667666666</timestamp>
### 	</bookmark>

	
def write_string_to_file(str_file_contents):
	# write file contens to file
	try:
   	 # This will create a new file or **overwrite an existing file**.
		
    		f = open(getConfigPath()+"bookmarks.xml", "w")
    		try:
        		f.write(str_file_contents)
    		finally:
        		f.close()
	except IOError:
    		pass

def getConfigPath():
	path = os.getenv("HOME") + "/.config/unity-bookmarks/" 
	if not os.path.exists(path):
		os.makedirs(path)	
	return path

def add_count_to_bookmark(name,amount=1):
	lines = ""
	for line in open(getConfigPath()+"bookmarks.xml"):
		line = line.strip()
		if name in line:
			testName = 'name="'+name+'"'
			if testName in line:
				if 'count' in line:
					count = line.split('count="')[1].split('" ')[0]
					count = int(count) + amount
					line = '<bookmark count="'+str(count)+'"  name="'+name+'">'
					print line
		lines += line + "\n"
	write_string_to_file(lines)

def reset_count(name):
	lines = ""
	for line in open(getConfigPath()+"bookmarks.xml"):
		line = line.strip()
		if name in line:
			testName = 'name="'+name+'"'
			if testName in line:
				if 'count' in line:
					line = '<bookmark count="'+str(1)+'"  name="'+name+'">'
					print line
		lines += line + "\n"
	write_string_to_file(lines)

def remove_bookmark(name):
	check = False
	lines = ""
	try:
		file_input = open(getConfigPath()+"bookmarks.xml")
		for line in file_input:
			line = line.strip()
			if 'name="'+name+'"' in line:
				check = True
			if check == False:
				lines += line + "\n"
			elif check == True:
				lines += ""
			if '</bookmark>' in line:
				if check == True:
					check = False				
	finally:
		file_input.close()
	write_string_to_file(lines)

def create_new_bookmark_XML(name, url, count=1):
	print "creating bookmark"
	# Create the minidom document
	doc = Document()

	bookmarks = doc.createElement("bookmarks")
	doc.appendChild(bookmarks)

	# Create the bookmark base element
	bookmark = doc.createElement("bookmark")
	bookmark.setAttribute('name', name)
	bookmark.setAttribute('count',count)
	bookmarks.appendChild(bookmark)

	# Create a url tag
	url_tag = doc.createElement("url")
	bookmark.appendChild(url_tag)

	# Give the url tag a value
	url_value = doc.createTextNode(url)
	url_tag.appendChild(url_value)

	# Create a timestamp tag
	timestamp_tag = doc.createElement("timestamp")
	bookmark.appendChild(timestamp_tag)

	# Give the timestamp tag a value
	timestamp_value = doc.createTextNode(strftime("%Y-%m-%d %H:%M:%S",gmtime()))
	timestamp_tag.appendChild(timestamp_value)
	
	# Print our newly created XML
	return doc.toprettyxml(indent="  ")

	
def addBookmark(name, url,count=1):
	# Read in previous bookmarks-xml, removes <bookmark>-end tag
	try:
    		file_contents = open(getConfigPath()+'bookmarks.xml').read().replace('</bookmarks>','').strip()
	except IOError:
    	# if file couldn't be read, make a new xml-file
    		file_contents = '<?xml version="1.0" ?>\n<bookmarks>'

	# create a new bookmark xml, removes xml header, removes <bookmarks>-start tag
	file_append = create_new_bookmark_XML(name, url,str(count)).replace('<?xml version="1.0" ?>','').replace('<bookmarks>','').strip()
	
	write_string_to_file(file_contents+"\n"+file_append)

def alterBookmark(oldname, newname, newurl):
	found = False
	lines = ""
	for line in open(getConfigPath()+"bookmarks.xml"):
		line = line.strip()
		if 'name="'+oldname+'"' in line:
			line = line.replace(oldname,newname)
			found  = True
		if found == True:
			if "<url>" in line: 
				line = "<url>"+newurl+"</url>"
				found = False				
		lines += line + "\n"
	write_string_to_file(lines)


	


#alterBookmark("faacebook","facebook","www.facebook.com")

#alterBookmark("yotube","youtube","www.youtube.com")
#addBookmark("sporza","www.sporza.be")
#addBookmark("facebook","www.facebook.be")
#addBookmark("standaard","www.standaard.be")

#add_count_to_bookmark("youtube")
#add_count_to_bookmark("sporza")
#add_count_to_bookmark("sporza")
#remove_bookmark("sporza")
