#!/usr/bin/python


from xml.dom.minidom import parse
import write_xml
import xml.sax
import os
def getConfigPath():
	path = os.getenv("HOME") + "/.config/unity-bookmarks/" 
	if not os.path.exists(path):
		os.makedirs(path)	
	return path

#### RETURN ALL ####
# Create a collection list
collection = []

# This handles the parsing of the content
class HandleCollection ( xml.sax.ContentHandler ):

   def __init__ ( self ):      
      global collection
      collection = []
      self.bookmark = {}
      self.url = False
      self.timestamp = False
      
   # Called at the start of an element
   def startElement ( self, name, attributes ):
      if name == 'bookmark':
	self.bookmark['count'] = attributes.getValue('count')
	self.bookmark['name'] = attributes.getValue('name')
      elif name == 'url':
        self.url = True
      elif name == 'timestamp':
        self.timestamp = True
     
   # Called at the end of an element
   def endElement ( self, name ):
      if name == 'bookmark':
         collection.append ( self.bookmark )
         self.bookmark = {}
      elif name == 'url':
         self.url = False
      elif name == 'timestamp':
         self.timestamp = False
    
   # Called to handle content besides elements
   def characters ( self, content ):
      if self.url:
         self.bookmark [ 'url' ] = content
      elif self.timestamp:
         self.bookmark [ 'timestamp' ] = content
     
def read_Xml():
	try:
		parser = xml.sax.make_parser()
		parser.setContentHandler ( HandleCollection() )
		parser.parse ( getConfigPath()+'bookmarks.xml' )
	except IOError:
		print "IOError"	
	return collection
###################################################################################################

#### RETURN LIST ####
# returns a list of bookmark id's
def getListId():
	outputList = []
	dom = parse(getConfigPath()+"bookmarks.xml")
	for  node in dom.getElementsByTagName('id'):
		nodeValue = node.toxml().replace('<id>','').replace('</id>','')
		outputList.append(nodeValue)
	return outputList
	
# returns a list of bookmarks URL
def getListUrl():
	outputList = []
	dom = parse(getConfigPath()+"bookmarks.xml")
	for  node in dom.getElementsByTagName('url'):
		nodeValue = node.toxml().replace('<url>','').replace('</url>','')
		outputList.append(nodeValue)
	return outputList

# returns a list of bookmarks names	
def getListName():
	outputList = []
	try:
		dom = parse(getConfigPath()+"bookmarks.xml")
		for  node in dom.getElementsByTagName('bookmark'):
			outputList.append(node.getAttribute("name"))
	except IOError:
		pass
	return outputList
	
def sortBookmarks():
	#TODO save the sorted bookmarks
	from operator import itemgetter
	bookmarks = read_Xml()
	print "------------------------------"
	for bookmark in bookmarks:
		bookmark['count'] = int(bookmark['count'])
	print "------------------------------"
	print bookmarks
	bookmarks.sort(key=itemgetter('count'))
	#bookmarks = bookmarks.reverse()
	for bookmark in bookmarks[::-1]:
		print "removing item :"+ bookmark['name']
		write_xml.remove_bookmark(bookmark['name'])
	for bookmark in bookmarks[::-1]:
		print "adding item :"+ bookmark['name']
		write_xml.addBookmark(bookmark['name'],bookmark['url'],bookmark['count'])
	try:
		try:
			from unity_bookmarks import indicator
			indicator.refresh_menu()
		except ImportError:
			pass
	except ImportError:
		pass  				
	indicator.refresh_menu()
		
#print getListUrl()
#print getListName()
#print getListLastOpend()

#dom = parse("bookmarks.xml")
#for  node in dom.getElementsByTagName('bookmark'):
#	print node.toxml()

#xmlTag = dom.getElementsByTagName('bookmark')
#for index in range(xmlTag)
#	print xmlTag[index].toxml()

# xmlData = xmlTag.replace('<bookmark>','').replace('</bookmark>','')

#print xmlTag
#print xmlData
#read_Xml()

#sortBookmarks()

