#!/usr/bin/python
# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Nick Lemaire lemaire.nick@gmail.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

"""Code to add AppIndicator."""

from gi.repository import Gtk, Unity, Dbusmenu # pylint: disable=E0611
from gi.repository import AppIndicator3 # pylint: disable=E0611
from unity_bookmarks import UnityBookmarksWindow, read_xml, write_xml
from unity_bookmarks_lib.helpers import get_media_file
from unity_bookmarks.AddbookmarkdialogDialog import AddbookmarkdialogDialog
import webbrowser
import gettext
from gettext import gettext as _
gettext.textdomain('unity-bookmarks')

class Indicator:
	bookmarks = []
    def __init__(self, window):
		self.window = window
        self.indicator = AppIndicator3.Indicator.new('unity-bookmarks', '', AppIndicator3.IndicatorCategory.APPLICATION_STATUS)
        self.indicator.set_status(AppIndicator3.IndicatorStatus.ACTIVE)

        icon_uri = get_media_file("unity-bookmarks.svg")
        icon_path = icon_uri.replace("file:///", '')
        self.indicator.set_icon(icon_path)

        #Uncomment and choose an icon for attention state. 
        #self.indicator.set_attention_icon("ICON-NAME")
        
        self.menu = Gtk.Menu()
        self.create_menu()
        
        self.launcher = Unity.LauncherEntry.get_for_desktop_id("extras-unity-bookmarks.desktop")
        self.ql = Dbusmenu.Menuitem.new()
        self.init_launcher()
        self.launcher.set_property("quicklist", self.ql)
        
		
	def create_menu(self):
		# Add items to Menu and connect signals.
        self.home = Gtk.ImageMenuItem.new_from_stock(Gtk.STOCK_HOME,Gtk.AccelGroup())
        self.home.set_always_show_image(True)
        self.home.connect("activate",self.on_Home_clicked)
        self.home.show()
        self.menu.append(self.home)

        self.addItem = Gtk.ImageMenuItem.new_from_stock(Gtk.STOCK_ADD,Gtk.AccelGroup())
        self.addItem.set_always_show_image(True)
        self.addItem.connect("activate",self.on_Add_clicked)
        self.addItem.show()
        self.menu.append(self.addItem) 

        self.separator = Gtk.SeparatorMenuItem()
        self.separator.show()
        self.menu.append(self.separator)
        
        try:
			global bookmarks
			bookmarks = read_xml.read_Xml()
			if len(bookmarks) > 10:
				submenu = Gtk.Menu()
				submenu.show()
				for i in range(0,9):
					bookmark = Gtk.MenuItem(bookmarks[i]['name'])
					bookmark.connect("activate",self.bookmark_clicked)
					bookmark.show()
					self.menu.append(bookmark)
				more = Gtk.MenuItem("More")
				more.show()
				more.set_submenu(submenu)
				self.menu.append(more)
				for i in range(9,len(bookmarks)):
					bookmark = Gtk.MenuItem(bookmarks[i]['name'])
					bookmark.connect("activate",self.bookmark_clicked)
					bookmark.show()
					submenu.append(bookmark)
			else:
				for i in range(0,len(bookmarks)):
					bookmark = Gtk.MenuItem(bookmarks[i]['name'])
					bookmark.connect("activate",self.bookmark_clicked)
					bookmark.show()
					self.menu.append(bookmark)
			if(len(bookmarks)>0):
				self.sep = Gtk.SeparatorMenuItem()
				self.sep.show()
				self.menu.append(self.sep)
		except IOError:
			pass

        self.preferences = Gtk.ImageMenuItem.new_from_stock(Gtk.STOCK_PREFERENCES, Gtk.AccelGroup())
        self.preferences.set_always_show_image(True)
        self.preferences.connect("activate",self.window.on_mnu_preferences_activate)
        self.preferences.show()
        self.menu.append(self.preferences)

        self.quit = Gtk.ImageMenuItem.new_from_stock(Gtk.STOCK_QUIT, Gtk.AccelGroup())
        self.quit.set_always_show_image(True)
        self.quit.connect("activate",self.window.on_mnu_close)
        self.quit.show()
        self.menu.append(self.quit)                        

        self.menu.show()
        self.indicator.set_menu(self.menu) 
        
    def on_Add_clicked(self,widget):
		self.window.on_Add_clicked(widget)
		
	def on_Home_clicked(self,widget):
		try:
			newwindow = UnityBookmarksWindow.UnityBookmarksWindow()
			if newwindow.getShown() == False:
				newwindow.show()
				newwindow.setShown(True)
				self.window = newwindow
			else:
				self.window.present()
		except NameError:
			self.window.present()

	def bookmark_clicked(self,widget):
		name = widget.get_label()
		print name
		global bookmarks
		for i in range(0,len(bookmarks)):
			if bookmarks[i]['name'] == name:
                print "Opening webbrowser tab - "+ bookmarks[i]['url']
				webbrowser.open_new_tab(bookmarks[i]['url'])
				write_xml.add_count_to_bookmark(name)
        read_xml.sortBookmarks()
		self.refresh_launcher()
		
	def init_launcher(self):
		try:
			bookmarks = read_xml.read_Xml()			
			for i in range(0,len(bookmarks)):
				if(i < 5):
					name = bookmarks[i]['name']
					print name
					bookmark = Dbusmenu.Menuitem.new()
					bookmark.property_set(Dbusmenu.MENUITEM_PROP_LABEL, name)
					bookmark.property_set_bool(Dbusmenu.MENUITEM_PROP_VISIBLE, True)
					bookmark.connect("item_activated", self.on_Bookmark_QL_clicked)
					self.ql.child_append(bookmark)
			if (len(bookmarks) > 0):
				separator = Dbusmenu.Menuitem.new();
				separator.property_set(Dbusmenu.MENUITEM_PROP_TYPE, Dbusmenu.CLIENT_TYPES_SEPARATOR)
				separator.property_set_bool(Dbusmenu.MENUITEM_PROP_VISIBLE, True)
				self.ql.child_append(separator)
		except IOError:
			pass
		item1 = Dbusmenu.Menuitem.new()
		item1.property_set(Dbusmenu.MENUITEM_PROP_LABEL, "Add Bookmark")
		item1.property_set_bool(Dbusmenu.MENUITEM_PROP_VISIBLE, True)
		item1.connect("item_activated", self.on_Add_QL_clicked)
		self.ql.child_append(item1)
		
		
	def refresh_launcher(self):
		children = self.ql.get_children()
		for child in children:
			#print 'refresh : ' + child.property_get(Dbusmenu.MENUITEM_PROP_LABEL)
			self.ql.child_delete(child)
		self.init_launcher()
		
	def on_Add_QL_clicked(self, menu_item, obj):
		self.on_Add_clicked(menu_item)
		
	def on_Bookmark_QL_clicked(self, menu_item, obj):
		name = menu_item.property_get(Dbusmenu.MENUITEM_PROP_LABEL)
		global bookmarks
		for i in range(0,len(bookmarks)):
			if bookmarks[i]['name'] == name:
                print "Opening webbrowser tab - "+ bookmarks[i]['url']
				webbrowser.open_new_tab(bookmarks[i]['url'])
				write_xml.add_count_to_bookmark(name)
        read_xml.sortBookmarks()
		self.refresh_launcher()
    
	def refresh_menu(self):
		self.menu = Gtk.Menu()
		self.create_menu()
		self.refresh_launcher()
    
ind = None
def new_application_indicator(window):
	global ind
	ind = Indicator(window)
	return ind.indicator

def refresh_menu():
	global ind
	ind.refresh_menu()
