# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Nick Lemaire lemaire.nick@gmail.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import optparse
import shutil
import gettext
import os
import ConfigParser
from gettext import gettext as _
gettext.textdomain('unity-bookmarks')

from gi.repository import Gtk # pylint: disable=E0611

from unity_bookmarks import UnityBookmarksWindow

from unity_bookmarks_lib import set_up_logging, get_version

def parse_options():
    """Support for command line options"""
    parser = optparse.OptionParser(version="%%prog %s" % get_version())
    parser.add_option(
        "-v", "--verbose", action="count", dest="verbose",
        help=_("Show debug messages (-vv debugs unity_bookmarks_lib also)"))
    (options, args) = parser.parse_args()

    set_up_logging(options)

def getConfigPath():
	path = os.getenv("HOME") + "/.config/unity-bookmarks/" 
	if not os.path.exists(path):
		os.makedirs(path)	
	return path

def main():
    'constructor for your class instances'
    parse_options()
    
    try:
		with open(getConfigPath() + 'indicator-checkfile') as f:
			pid = f.read()
			if os.path.exists("/proc/"+pid):
				pass
			else:
				os.remove(getConfigPath() + 'indicator-checkfile')
				startApplication()
				
	except IOError as e:
		startApplication()

    # Run the application.    
    
def startApplication():
	check = open(getConfigPath() + "indicator-checkfile", "w")
	pid = str(os.getpid())
	check.write(pid)
	check.close()
	window = UnityBookmarksWindow.UnityBookmarksWindow()
	
	config = ConfigParser.ConfigParser()
	try:
		cFile=open(getConfigPath() + "unity-bookmarks.conf")
		cFile.close()
	except IOError:
		write_configFile(True, True, config)
	config.read(getConfigPath() + "unity-bookmarks.conf")
	if config.get("general", "showhomeonstart") == "True":
		window.show()
	Gtk.main()

def getConfigPath():
	path = os.getenv("HOME") + "/.config/unity-bookmarks/" 
	if not os.path.exists(path):
		os.makedirs(path)	
	return path
	
def getAutostartPath():
	path = os.getenv("HOME") + "/.config/autostart/"
	if not os.path.exists(path):
		os.makedirs(path)	
	return path

def write_configFile(auto, main, config):
	cFile = open(getConfigPath() + "unity-bookmarks.conf", "w")
	config.add_section("general")
	config.set("general","autostart",auto)
	try:
		shutil.copyfile("/usr/share/applications/extras-unity-bookmarks.desktop", getAutostartPath() + "extras-unity-bookmarks.desktop")
	except:
		pass 
	config.set("general","showhomeonstart",main)
	config.write(cFile)
