# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Pablo SEMINARIO <pabluk@gmail.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

# This is your preferences dialog.
#
# Define your preferences in
# data/glib-2.0/schemas/net.launchpad.ubatar.gschema.xml
# See http://developer.gnome.org/gio/stable/GSettings.html for more info.

from gi.repository import Gtk, Gio # pylint: disable=E0611

import gettext
from gettext import gettext as _
gettext.textdomain('ubatar')

import logging
logger = logging.getLogger('ubatar')

from launchpadlib.launchpad import Launchpad

from ubatar.plugins import get_installed_services
from ubatar.AuthGravatarDialog import AuthGravatarDialog
from ubatar.AuthTwitterDialog import AuthTwitterDialog
from ubatar_lib.PreferencesDialog import PreferencesDialog
from ubatar_lib.keyring import SecretServiceKeyring

class PreferencesUbatarDialog(PreferencesDialog):
    __gtype_name__ = "PreferencesUbatarDialog"

    def finish_initializing(self, builder): # pylint: disable=E1002
        """Set up the preferences dialog"""
        super(PreferencesUbatarDialog, self).finish_initializing(builder)

        # Bind each preference widget to gsettings
        self.settings = Gio.Settings("net.launchpad.ubatar")

        # Code for other initialization actions should be added here.
        self.services = get_installed_services()
        self.load_service_widgets()

    def load_service_widgets(self):
        grid_services = self.builder.get_object('grid_services')
        grid_services.set_orientation(Gtk.Orientation.VERTICAL)
        for service in self.services:
            lbl_service = Gtk.Label(service.title)
            grid_services.add(lbl_service)
            sw_service = Gtk.Switch()
            self.settings.bind('%s-enable' % service.name, sw_service, 'active', Gio.SettingsBindFlags.DEFAULT)
            sw_service.set_active(self.settings.get_boolean('%s-enable' % service.name))
            if service.is_default:
                sw_service.set_sensitive(False)
            grid_services.attach_next_to(sw_service, lbl_service, Gtk.PositionType.RIGHT, 1, 1)
            if service.use_auth:
                sw_service.set_sensitive(self.settings.get_boolean('%s-authorized' % service.name))
                btn_auth_service = Gtk.Button(_('Authorize'))
                btn_auth_service.set_name('btn_auth_%s' % service.name)
                btn_auth_service.connect('clicked', self.on_btn_auth_clicked, sw_service)
                grid_services.attach_next_to(btn_auth_service, sw_service, Gtk.PositionType.RIGHT, 1, 1)
        grid_services.show_all()

    def on_btn_auth_clicked(self, widget, sw_service):
        if widget.get_name() == 'btn_auth_gravatar':
            dialog = AuthGravatarDialog()
            response = dialog.run()
            if response == Gtk.ResponseType.OK:
                email =  dialog.ui.ent_email.get_text()
                password = dialog.ui.ent_password.get_text()
                keyring = SecretServiceKeyring()
                keyring.set_password('gravatar', email, password)
                self.settings.set_boolean('gravatar-authorized', True)
                sw_service.set_active(self.settings.get_boolean('gravatar-authorized'))
                sw_service.set_sensitive(self.settings.get_boolean('gravatar-authorized'))
            dialog.hide()

        if widget.get_name() == 'btn_auth_launchpad':
            try:
                launchpad = Launchpad.login_with('Ubatar', 'production')
                self.settings.set_boolean('launchpad-authorized', True)
                sw_service.set_active(self.settings.get_boolean('launchpad-authorized'))
                sw_service.set_sensitive(self.settings.get_boolean('launchpad-authorized'))
            except:
                # TODO: catch launchpadlib.credentials.EndUserDeclinedAuthorization
                #       and when user close the browser window.
                pass

        if widget.get_name() == 'btn_auth_twitter':
            dialog = AuthTwitterDialog()
            response = dialog.run()
            if response == Gtk.ResponseType.OK:
                sw_service.set_active(self.settings.get_boolean('twitter-authorized'))
                sw_service.set_sensitive(self.settings.get_boolean('twitter-authorized'))
            dialog.hide()
