# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Pablo SEMINARIO <pabluk@gmail.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from gi.repository import Gtk, Gio # pylint: disable=E0611

from ubatar_lib.helpers import get_builder
from ubatar_lib.keyring import SecretServiceKeyring

import gettext
from gettext import gettext as _
gettext.textdomain('ubatar')

class AuthGravatarDialog(Gtk.Dialog):
    __gtype_name__ = "AuthGravatarDialog"

    def __new__(cls):
        """Special static method that's automatically called by Python when 
        constructing a new instance of this class.
        
        Returns a fully instantiated AuthGravatarDialog object.
        """
        builder = get_builder('AuthGravatarDialog')
        new_object = builder.get_object('auth_gravatar_dialog')
        new_object.finish_initializing(builder)
        return new_object

    def finish_initializing(self, builder):
        """Called when we're finished initializing.

        finish_initalizing should be called after parsing the ui definition
        and creating a AuthGravatarDialog object with it in order to
        finish initializing the start of the new AuthGravatarDialog
        instance.
        """
        # Get a reference to the builder and set up the signals.
        self.builder = builder
        self.ui = builder.get_ui(self)


        settings = Gio.Settings("net.launchpad.ubatar")
        widget = self.builder.get_object('ent_email')
        settings.bind("gravatar-login", widget, "text", Gio.SettingsBindFlags.DEFAULT)

        ent_email = self.builder.get_object('ent_email')
        ent_password = self.builder.get_object('ent_password')
        keyring = SecretServiceKeyring()
        stored_password = keyring.get_password('gravatar', ent_email.get_text())
        if stored_password:
            ent_password.set_text(stored_password)


    def on_btn_ok_clicked(self, widget, data=None):
        """The user has elected to save the changes.

        Called before the dialog returns Gtk.ResponseType.OK from run().
        """
        pass

    def on_btn_cancel_clicked(self, widget, data=None):
        """The user has elected cancel changes.

        Called before the dialog returns Gtk.ResponseType.CANCEL for run()
        """
        pass


if __name__ == "__main__":
    dialog = AuthGravatarDialog()
    dialog.show()
    Gtk.main()
