#!/usr/bin/python
# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Pablo SEMINARIO <pabluk@gmail.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import sys
import os.path
import unittest
sys.path.insert(0, os.path.realpath(os.path.join(os.path.dirname(__file__), "..")))

from gi.repository import GdkPixbuf
from ubatar_lib.ubatarconfig import get_data_file
from ubatar_lib.utils import pixbuf_normalize


class TestUbatar(unittest.TestCase):
    def setUp(self):
        example_img = get_data_file('media', 'empty.png')
        self.pixbuf = GdkPixbuf.Pixbuf.new_from_file(example_img)

    def test_pixbuf_normalize(self):
        self.pixbuf = self.pixbuf.scale_simple(1204, 768, GdkPixbuf.InterpType.BILINEAR)

        size = 600
        pixbuf = pixbuf_normalize(self.pixbuf, size)
        self.assertEqual(pixbuf.get_width(), size)
        self.assertEqual(pixbuf.get_height(), size)

if __name__ == '__main__':    
    unittest.main()
