# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 David Planella <david.planella@ubuntu.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import optparse

TEXTDOMAIN = 'qreator'
LOCALEDIR = '/opt/extras.ubuntu.com/qreator/share/locale/'
import locale
from locale import gettext as _
locale.bindtextdomain(TEXTDOMAIN, LOCALEDIR)
locale.bind_textdomain_codeset(TEXTDOMAIN, 'UTF-8')
locale.textdomain(TEXTDOMAIN)

from gi.repository import GtkClutter
## Needs to be called here, otherwise the GtkChamplain widget needs to be
## explicitly connected to signals and methods defined
GtkClutter.init([])
from gi.repository import Gtk  # pylint: disable=E0611

from qreator import QreatorWindow

from qreator_lib import set_up_logging, get_version


def parse_options():
    """Support for command line options"""
    parser = optparse.OptionParser(version="%%prog %s" % get_version())
    parser.add_option(
        "-v", "--verbose", action="count", dest="verbose",
        help=_("Show debug messages (-vv debugs qreator_lib also)"))
    parser.add_option(
        "-u", "--url", dest="view", action="store_const", const="url",
        help=_("Create a QR code for a URL"))
    parser.add_option(
        "-t", "--text", dest="view", action="store_const", const="text",
        help=_("Create a QR code from text"))
    parser.add_option(
        "-l", "--location", dest="view", action="store_const",
        const="location", help=_("Create a QR code for a location"))
    parser.add_option(
        "-w", "--wifi", dest="view", action="store_const", const="wifi",
        help=_("Create a QR code for WiFi settings"))
    (options, args) = parser.parse_args()

    set_up_logging(options)
    return options


def main():
    'constructor for your class instances'
    options = parse_options()

    # Run the application
    window = QreatorWindow.QreatorWindow()
    window.show()
    if getattr(options, 'view', None) is not None:
        if options.view == 'url':
            window.on_qr_url_clicked()
        elif options.view == 'text':
            window.on_qr_text_clicked()
        elif options.view == 'location':
            window.on_qr_location_clicked()
        elif options.view == 'wifi':
            window.on_qr_wifi_clicked()
        window.ui.notebook1.set_current_page(QreatorWindow.PAGE_QR)
    Gtk.main()
