# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
##
# Project: ppasc - PPA Software Center
# Author: Marco Scarpetta <marcoscarpetta@mailoo.org>
# Copyright: 2012 Marco Scarpetta
# License: GPL-3
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
# more details.
#
# On Debian GNU/Linux systems, the full text of the GNU General Public License
# can be found in the file /usr/share/common-licenses/GPL-3.
##

import urllib2 
import re
from HTMLParser import HTMLParser
import sys
from launchpadlib.launchpad import Launchpad
from softwareproperties.SoftwareProperties import SoftwareProperties
import apt
import apt_pkg
import platform

apt_pkg.init_config()
apt_pkg.init_system()

import gettext
from gettext import gettext as _
gettext.textdomain('ppasc')

vcs = (_('Same version'),_('Major'),_('Not present'),_('Minor'))

class LaunchpadSearcher(HTMLParser):

   def __init__(self):
      HTMLParser.__init__(self)
      self.signal = 0 
      self.data = []

   def handle_starttag(self, tag, attrs):
      if tag == 'tr':
         for name, value in attrs:
            if name == 'class' and value == 'ppa_batch_row':
               self.signal = 1 
      if tag == 'a' and self.signal == 1:
         for name, value in attrs:
            if name == 'href':
               self.data.append(value)

   def handle_endtag(self, tag):
      if tag == 'tr':
         self.signal = 0 
	
   def get_ppas(self):
      ppas = []
      for name in self.data:
         splitted = re.split('/',name)
         ppas.append((splitted[1][1:],splitted[3]))
      return ppas
	
   def clean(self):
      self.signal = 0 
      self.data = []

def launchpad_search(string):
	result = []
	p = LaunchpadSearcher()
	n = 0
	while 1:
		f = urllib2.urlopen(
			'https://launchpad.net/ubuntu/+ppas?name_filter='+string+'&batch=300&start='+str(300*n))
		html = f.read()
		p.feed(html)
		ppas = p.get_ppas()
		if len(ppas) == 0:
			break
		for tup in ppas:
			result.append(tup)
		p.clean()
		n=n+1
	p.close()
	return result

def get_status(ppa):
   sp = SoftwareProperties()
   ppas = []
   repos=sp.get_isv_sources()
   for repo in repos:
      if str(repo).startswith('deb http://ppa.launchpad.net/'):
         ppas.append(str(repo).split('/')[3]+'/'+str(repo).split('/')[4])
   if ppa in ppas:
      return _('Already present')
   else:
      return _('Not present')

def get_packages(string,exact,add_f,end_f,stop):
   cache = apt_pkg.Cache()
   try:
      ppas = launchpad_search(string)
   except:
      end_f()
      return
   
   for ppa in ppas:
      if stop():
         break
      desired_dist_and_arch = 'https://api.launchpad.net/devel/ubuntu/'+platform.dist()[2]+'/i386'
      cachedir = "~/.launchpadlib/cache/"
      lp_ = Launchpad.login_anonymously('ppasoftwarecenter', 'edge', cachedir, version='devel')
      try:
         owner = lp_.people[ppa[0]]
         archive = owner.getPPAByName(name=ppa[1])
        
         for individualarchive in archive.getPublishedBinaries(binary_name=string,exact_match=exact,status='Published',distro_arch_series=desired_dist_and_arch):
            if stop():
               break
            if individualarchive.binary_package_name in cache:
               d=apt_pkg.DepCache(cache)
               local=d.get_candidate_ver(cache[individualarchive.binary_package_name]).ver_str
               vc=apt.VersionCompare(local,individualarchive.binary_package_version)
               if vc>0:
                  vc=1
               elif vc<0:
                  vc=-1
            else:
               vc=2
            add_f(owner.name+'/'+archive.name,
            get_status(owner.name+'/'+archive.name),
            vcs[vc],
            individualarchive.binary_package_name,
            individualarchive.binary_package_version,
            archive.description,
            archive.web_link)
      except:
         pass

   end_f()
