#!/usr/bin/env python
# -*- coding: utf-8 -*-

### BEGIN LICENSE
# Copyright © 2012 Vsevolod Velichko <torkvema@gmail.com>
# Copyright © 2012 Carlos da Costa <c.costa@outlook.com>
# Copyright © 2012 Erik Christiansson <erik@christiansson.net>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from . import TrackingService

import re
from dateutil.parser import parse as parsedate

class DhlDeService(TrackingService):
    name = 'DHL Germany'
    url = 'http://nolp.dhl.de/nextt-online-public/set_identcodes.do?idc=%(number)s'
    def _get_page(self):
        # setup
        super(DhlDeService, self)._fetch_url('http://nolp.dhl.de/nextt-online-public/changeLanguage?lng=en', None, {})
        return super(DhlDeService, self)._get_page()
    def _parse_page(self, html):
        html = html.decode('utf-8')
        res = re.search(r'<table[^>]* class="full eventList">.*?<tbody>(.*?)</tbody>', html, re.DOTALL)
        if res is None:
            return []
        html = res.group(1)
        html = re.sub(r'<!--.*?-->', '', html, re.DOTALL)
        html = re.sub(r'<div[^>]*>', '', html)
        html = re.sub(r'</div>', '', html)
        results = []
        for res in re.findall(r'<tr[^>]*>\s*<td[^>]*>\s*(.*?)\s*</td>\s*<td[^>]*>\s*(.*?)\s*</td>\s*<td[^>]*>\s*(.*?)\s*</td>\s*</tr>', html, re.DOTALL):
            date = re.sub(r'\s+', ' ', res[0].strip())
            date = date[4:-1].strip() # remove DOW from start and 'h' from end
            date = parsedate(date, dayfirst=True)
            location = re.sub(r'\s+', ' ', res[1].strip())
            operation = re.sub(r'\s+', ' ', res[2].strip())
            results.append((operation, date, location))

        return results

class DhlmultishippingSeService(TrackingService):
    """DHL shipments that are not parcels"""
    name = 'DHLMultishipping.se'
    url = 'http://www.dhlmultishipping.se/customers/dhl/parcelevents_status.jsp?consignmentNo=%(number)s&lang=en'
    def _parse_page(self, html):
        html = html.decode('utf-8')
        res = re.search(r'<table[^>]*>.*?</tr>(.*?)</table>', html, re.DOTALL)
        if res is None:
            return []
        html = res.group(1)
        results = []
        for res in re.findall(r'<tr[^>]*>.*?<font.*?>(.*?)</font>.*?<font.*?>(.*?)</font>.*?<font.*?>(.*?)</font>.*?<font.*?>(.*?)</font>.*?<font.*?>(.*?)</font>.*?<font.*?>(.*?)</font>', html, re.DOTALL):
            action = res[1].strip()
            date = parsedate(res[3].strip())
            location = res[4].strip()
            results.append((action, date, location))
        return results
