#!/usr/bin/env python
# -*- coding: utf-8 -*-

### BEGIN LICENSE
# Copyright © 2012 Vsevolod Velichko <torkvema@gmail.com>
# Copyright © 2012 Carlos da Costa <c.costa@outlook.com>
# Copyright © 2012 Erik Christiansson <erik@christiansson.net>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

'''Fetches parcel statuses from different Post servers'''

from gevent import monkey
monkey.patch_socket()
monkey.patch_ssl()

import os

import postservices
service_classes = []
for i in os.walk(postservices.__path__[0]):
    if i[0] != postservices.__path__[0]:
        continue
    for j in i[2]:
        if j.startswith('__init__') or not j.endswith('.py'):
            continue
        j = j.split('.')[0]
        module_dict = __import__("postservices", globals(), locals(), [j]).__dict__[j].__dict__
        for clname in module_dict:
            if isinstance(module_dict[clname], type) and issubclass(module_dict[clname], postservices.TrackingService) and clname != 'TrackingService':
                service_classes.append(clname)
                globals()[clname] = module_dict[clname]

def get_services():
    return service_classes

if __name__ == '__main__':
    import sys, codecs, locale
    import logging
    logging.basicConfig(level=logging.DEBUG, format="%(asctime)s - %(levelname)s - %(message)s")
    sys.stdout = codecs.getwriter(locale.getpreferredencoding())(sys.stdout)
    #service = RussianpostService('CG077165712US')
    #service = EmspostRuService('CG077165712US')
    #service = PostaSiService('RA316816466SI')
    #service = ParcelForceNetService('EK034679967GB')
    #service = PostdanmarkDkService('TS123456789DK')
    #service = SwisspostChService('RU470249572CH')
    #service = UspsComService('420917419405515901033236726959')
    #service = FedexComService('005794574062094')
    #service = UpsComService('1ZX799330362743967')
    #service = UkrposhtaComService('RB041697087UA')
    #service = DhlDeService('129921786448')
    #service = UpsComService('1Z882E910397601345')
    #service = CorreiosComService('RD024810847SE')
    #service = PrivpakSchenkerNuService('4199854203482')
    #service = SchenkerNuService('6273636354')
    service = DhlmultishippingSeService('6288206664')
    for i in service.fetch():
        print u'\t'.join([unicode(j) for j in i])
