#!/usr/bin/python
# -*- coding: utf-8 -*-

#
# Copyright 2012 Dimitrios - Georgios Kontopoulos
#    <dgkontopoulos[at]member[dot]fsf[dot]org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License, as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details at
#  <http://www.gnu.org/licenses>.
#
try:
     import appindicator
     have_indicator = True
except:
     have_indicator = False
import getpass
import gobject
import gtk
import locale
import os.path
import subprocess
import sys

from locale import gettext as _
locale.bindtextdomain('OrthCal_ind', '/opt/extras.ubuntu.com/orthcal/translations/locale')
locale.textdomain('OrthCal_ind')
 
class StatusIcon:
    def __init__(self):
        self.statusicon = gtk.StatusIcon()
        self.statusicon.set_from_file("/opt/extras.ubuntu.com/orthcal/content/images/orthcal_ind.png") 
        self.statusicon.connect("popup-menu", self.right_click_event)
        self.statusicon.set_title("OrthCal")       
		
    def right_click_event(self, icon, button, time):
        menu = gtk.Menu()

        feastsJulian = _("Today's Feasts (Julian/Old Calendar)")
        menu_feastsJulian = gtk.MenuItem(feastsJulian)
        menu.append(menu_feastsJulian)
        menu_feastsJulian.connect('activate', julian_calendar, feastsJulian)
        menu_feastsJulian.show()

        feastsRJulian = _("Today's Feasts (Revised Julian/New Calendar)")
        menu_feastsRJulian = gtk.MenuItem(feastsRJulian)
        menu.append(menu_feastsRJulian)
        menu_feastsRJulian.connect('activate', rjulian_calendar, feastsRJulian)
        menu_feastsRJulian.show()

        separator1 = gtk.SeparatorMenuItem()
        menu.append(separator1)
        separator1.show()
        
        options = _('Options')
        menu_options = gtk.MenuItem(options)
        menu.append(menu_options)
        menu_options.connect('activate', OrthCal_options, options)
        menu_options.show()

        about = _('About OrthCal')
        menu_about = gtk.MenuItem(about)
        menu.append(menu_about)
        menu_about.connect('activate', about_OrthCal, about)
        menu_about.show()

        separator2 = gtk.SeparatorMenuItem()
        menu.append(separator2)
        separator2.show()

        quit = _('Quit')
        menu_quit = gtk.MenuItem(quit)
        menu.append(menu_quit)
        menu_quit.connect('activate', destroy, quit)
        menu_quit.show()
        
        menu.popup(None, None, gtk.status_icon_position_menu, button, time, self.statusicon)
       
def about_OrthCal(w, about):
    subprocess.call('/opt/extras.ubuntu.com/orthcal/bin/OrthCal.pl about&', shell=True)

def destroy(appindicator, data=None):
    gtk.mainquit()

def julian_calendar(w, feastsJulian):
    subprocess.call('/opt/extras.ubuntu.com/orthcal/bin/OrthCal.pl Julian&', shell=True)

def OrthCal_options(w, options):
    subprocess.call('/opt/extras.ubuntu.com/orthcal/bin/OrthCal.pl options&', shell=True)

def rjulian_calendar(w, feastsRJulian):
    subprocess.call('/opt/extras.ubuntu.com/orthcal/bin/OrthCal.pl RJulian&', shell=True)


if __name__ == '__main__':
    if have_indicator == True:
        ind = appindicator.Indicator('OrthCal', '/opt/extras.ubuntu.com/orthcal/content/images/orthcal_ind.png', appindicator.CATEGORY_OTHER)
        ind.set_status(appindicator.STATUS_ACTIVE)

        menu = gtk.Menu()

        feastsJulian = _("Today's Feasts (Julian/Old Calendar)")
        menu_feastsJulian = gtk.MenuItem(feastsJulian)
        menu.append(menu_feastsJulian)
        menu_feastsJulian.connect('activate', julian_calendar, feastsJulian)
        menu_feastsJulian.show()

        feastsRJulian = _("Today's Feasts (Revised Julian/New Calendar)")
        menu_feastsRJulian = gtk.MenuItem(feastsRJulian)
        menu.append(menu_feastsRJulian)
        menu_feastsRJulian.connect('activate', rjulian_calendar, feastsRJulian)
        menu_feastsRJulian.show()

        separator1 = gtk.SeparatorMenuItem()
        menu.append(separator1)
        separator1.show()
        
        options = _('Options')
        menu_options = gtk.MenuItem(options)
        menu.append(menu_options)
        menu_options.connect('activate', OrthCal_options, options)
        menu_options.show()

        about = _('About OrthCal')
        menu_about = gtk.MenuItem(about)
        menu.append(menu_about)
        menu_about.connect('activate', about_OrthCal, about)
        menu_about.show()

        separator2 = gtk.SeparatorMenuItem()
        menu.append(separator2)
        separator2.show()

        quit = _('Quit')
        menu_quit = gtk.MenuItem(quit)
        menu.append(menu_quit)
        menu_quit.connect('activate', destroy, quit)
        menu_quit.show()

        ind.set_menu(menu)

        gtk.main()
    else:
	StatusIcon()
	gtk.main()
