# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Marian Lux marian.lux@mlux.at
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from gi.repository import Gtk # pylint: disable=E0611

from interest_calculation_lib.helpers import get_builder

import locale
from locale import gettext as _
locale.textdomain('interest-calculation')

import commands
import math
from gi.repository import Notify
import csv


class Tools(Gtk.Dialog): 
	
	def __init__(self):
		#init notification
		Notify.init('Application')
		pass
	
	 #def finish_initializing(self, builder):
		
	#formats a float to a string with following schema
	#dddddd.ff => ddd.ddd,ff
	#e.g. to call for displaying:
	#str(self.tools.formatFloatToStringoutput(format(round(self.spinbuttonAmount.get_value(),2),'.2f')))
	def formatFloatToStringoutput(self, v):
		
		s = str(v)
		sarray = s.split('.')
		if len(sarray) < 2:
			#make no formatting
			return s
		l = len(sarray[0])
		return ".".join([sarray[0][-i-3:-i or l] for i in range(0, l, 3)][::-1]) + "," + sarray[1]
		
	#formats a string to a float with following schema
	#ddd.ddd,ff => dddddd.ff
	def formatStringoutputToFloat(self, v):
		sarray = v.split('.')
		i = 1
		print len(sarray)
		while(i < len(sarray)):
			sarray[0] = sarray[0] + sarray[i]
			i = i + 1
		return sarray[0]

	#displays system-notification with given title, text and picture
	def showSystemNotification(self, title, text, picture):
		notification = Notify.Notification.new (title, text, picture)
		notification.show()
		
	#opens a filechooser dialog for csv-files
	#returns Gtk.ResponseType.OK if SAVE pressed and path+filename
	def fileChooserDialogCSV(self):
		dialog = Gtk.FileChooserDialog(_("Please choose a file"), self,Gtk.FileChooserAction.SAVE,(Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL,Gtk.STOCK_SAVE, Gtk.ResponseType.OK))
		
		filters = [];
		all_filter = Gtk.FileFilter();
		all_filter.set_name('CSV Files');
		all_filter.add_pattern('*.csv');
		dialog.add_filter(all_filter)
		
		response = dialog.run()
		filename = dialog.get_filename()
		dialog.destroy()
		return [response, filename]
