# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Marian Lux marian.lux@mlux.at
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE
from gi.repository import Gtk # pylint: disable=E0611

from interest_calculation_lib.helpers import get_builder

import locale
from locale import gettext as _
locale.textdomain('interest-calculation')


import commands
import math
import csv


#own classes
import Tools
import MluxaboutDialog

class PaymentinadvanceDialog(Gtk.Dialog):
    __gtype_name__ = "PaymentinadvanceDialog"

    def __new__(cls):
        """Special static method that's automatically called by Python when 
        constructing a new instance of this class.
        
        Returns a fully instantiated PaymentinadvanceDialog object.
        """
        builder = get_builder('PaymentinadvanceDialog')
        new_object = builder.get_object('paymentinadvance_dialog')
        new_object.finish_initializing(builder)
        return new_object

    def finish_initializing(self, builder):
        """Called when we're finished initializing.

        finish_initalizing should be called after parsing the ui definition
        and creating a PaymentinadvanceDialog object with it in order to
        finish initializing the start of the new PaymentinadvanceDialog
        instance.
        """
        # Get a reference to the builder and set up the signals.
        self.builder = builder
        self.ui = builder.get_ui(self)
        
        #make toolbar look native
        self.toolbarTop = self.builder.get_object("toolbarTop")
        context = self.toolbarTop.get_style_context()
        context.add_class(Gtk.STYLE_CLASS_PRIMARY_TOOLBAR)
        
        #load tools
        self.tools = Tools.Tools()
		
        #for click-events
        self.toolbuttonLogo = self.builder.get_object("toolbuttonLogo")
        
        #elements of dialog for calculation
        self.spinbuttonAmount = self.builder.get_object("spinbuttonAmount")
        self.spinbuttonDuration = self.builder.get_object("spinbuttonDuration")
        self.spinbuttonRatePerCent = self.builder.get_object("spinbuttonRatePerCent")
        self.checkbuttonCompoundInterest = self.builder.get_object("checkbuttonCompoundInterest")
		
		#elements to set after calculation - Total Results
		self.entryFinalAmount = self.builder.get_object("entryFinalAmount")
		self.entryFinalAmount.set_alignment(0.5)
		self.entryTotalInterest = self.builder.get_object("entryTotalInterest")
        self.entryTotalInterest.set_alignment(0.5)
		self.liststoreDetailedResults = self.builder.get_object("liststoreDetailedResults")   

		#special elements
		self.scrolledwindowTreeView = self.builder.get_object("scrolledwindowTreeView")  

        
    def on_toolbuttonLogo_clicked(self, widget):
        print "logo clicked"
        #open about dialog
		dlgMluxaboutDialog = MluxaboutDialog.MluxaboutDialog()
		result = dlgMluxaboutDialog.run()
		dlgMluxaboutDialog.destroy()
		
   
    def on_toolbuttonCalculate_clicked(self, widget):
		print "calculate clicked"
		#leave current focus for including current inputs on calculation
		self.toolbuttonLogo.grab_focus()
		
		self.clear_liststore()
        
		#get input-data
		#get amount
		amount = self.spinbuttonAmount.get_value()
		try:
			float_amount = float(amount)
		except ValueError:
			float_amount = 0
        #get duration
        duration = self.spinbuttonDuration.get_value()
		try:
			int_duration = int(duration)
		except ValueError:
			int_duration = 0
        #get ratepercent
        ratepercent = self.spinbuttonRatePerCent.get_value()
		try:
			float_ratepercent = float(ratepercent)
		except ValueError:
			float_ratepercent = 0
        
		#calculate results:
		#show detailed results
		y = 1
		total_interest_before = 0
		while(y <= int_duration):
			#compound interest
			if self.checkbuttonCompoundInterest.get_active() == True:
				#compound interest
				#finalamount = startingcapital * (1 + interest / 100) ^ duration
				finalamount = float_amount * pow((1 + (float_ratepercent / 100)), y)
			else:
				#linear interest
				#finalamount = startingcapital + startingcapital * duration * (interest / 100)
				finalamount = float_amount + (float_amount * y * (float_ratepercent / 100))
				
			str_finalamount = str(self.tools.formatFloatToStringoutput(format(round(finalamount,2),'.2f')))	
			str_totalinterest = str(self.tools.formatFloatToStringoutput(format(round(finalamount-float_amount,2),'.2f')))
			
			str_current_interest = str(self.tools.formatFloatToStringoutput(format(round(finalamount-float_amount - total_interest_before,2),'.2f')))
			self.liststoreDetailedResults.append([str(y), str_current_interest, str_totalinterest, str_finalamount])
			
			total_interest_before = finalamount-float_amount
			y = y + 1
		
		#total results:
		self.entryFinalAmount.set_text(str_finalamount)
		self.entryTotalInterest.set_text(str_totalinterest)
		
		#set outputfiels active
		self.entryFinalAmount.set_sensitive(True)
		self.entryTotalInterest.set_sensitive(True)
		
		#set size of treeview and stop on 13 to get the window bigger and bigger
		if int_duration >= 9:
			self.scrolledwindowTreeView.set_min_content_height(238)
		else:
			self.scrolledwindowTreeView.set_min_content_height(26 + (int_duration * 23))

	def on_toolbuttonClear_clicked(self, widget):
		print "toolbuttonClear clicked"
		#clear inputs
		self.spinbuttonAmount.set_value(0)
		self.spinbuttonDuration.set_value(1)
		self.spinbuttonRatePerCent.set_value(5.00)
		self.checkbuttonCompoundInterest.set_active(True)
		#clear outputs
		self.entryFinalAmount.set_text("")
		self.entryTotalInterest.set_text("")
		self.clear_liststore()
		
	
	def on_toolbuttonExport_clicked(self, widget):
		print "export clicked"
		#run filechooser-dialog for csv-files
		response, filename = self.tools.fileChooserDialogCSV()
        if response == Gtk.ResponseType.OK:
			if filename[-4:].lower() != ".csv":
				filename = filename + ".csv"
			#get compound-interest-checkbox-value
			compound_interest_value = ""
			if self.checkbuttonCompoundInterest.get_active() == True:
				compound_interest_value = "yes"
			else:
				compound_interest_value = "no"
			#set header
			try:
				csvWriter = csv.writer(open(filename, 'wb'), delimiter=';', quotechar='\'', quoting=csv.QUOTE_MINIMAL)
				csvWriter.writerow(['Year'] +['Interest_($)'] +['Accumulated_Interest_($)'] + ['Total_Capital_($)'] + 
					[''] + ['Starting_amount_($):'] + [str(self.tools.formatFloatToStringoutput(format(round(self.spinbuttonAmount.get_value(),2),'.2f')))] + 
					[''] + ['Duration_(years):'] + [str(self.tools.formatFloatToStringoutput(format(round(self.spinbuttonDuration.get_value(),2),'.2f')))] + 
					[''] +['Interest_rate_(%):'] + [str(self.tools.formatFloatToStringoutput(format(round(self.spinbuttonRatePerCent.get_value(),2),'.2f')))] +
					[''] + ['Compound_Interest_(yearly):'] + [compound_interest_value])
				#fill with table-inputs
				for row in self.liststoreDetailedResults:
					csvWriter.writerow([row[0]] +[row[1]] +[row[2]] + [row[3]])
				#systemnotification if csv-file correctly saved on filesystem
				self.tools.showSystemNotification('CSV-Export', 
					'The CSV-File was created successfully!\nYou will find the file on: \n\"' + filename + '\"',
					 'document-save')
			except IOError:
				print "exception: IO Error occured"
				self.tools.showSystemNotification('Error on CSV-Export', 'The CSV-File was not created!\nAn error occured. Maybe you have insufficient privileges on this location to write the file:\n"'
					+ filename + '\"','dialog-error')
		
	def clear_liststore(self):
		#clear list and resize window to minimum
		self.liststoreDetailedResults.clear()
		self.resize(1,1)
		self.scrolledwindowTreeView.set_min_content_height(1)
		#set outputfiels inactive
		self.entryFinalAmount.set_sensitive(False)
		self.entryTotalInterest.set_sensitive(False)
		
	
		
if __name__ == "__main__":
    dialog = PaymentinadvanceDialog()
    dialog.show()
    Gtk.main()
