# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Marian Lux marian.lux@mlux.at
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from gi.repository import Gtk # pylint: disable=E0611

from interest_calculation_lib.helpers import get_builder

import locale
from locale import gettext as _
locale.textdomain('interest-calculation')


import commands
import math
import csv


#own classes
import Tools
import MluxaboutDialog

class MonthlyinpaymentDialog(Gtk.Dialog):
    __gtype_name__ = "MonthlyinpaymentDialog"

    def __new__(cls):
        """Special static method that's automatically called by Python when 
        constructing a new instance of this class.
        
        Returns a fully instantiated MonthlyinpaymentDialog object.
        """
        builder = get_builder('MonthlyinpaymentDialog')
        new_object = builder.get_object('monthlyinpayment_dialog')
        new_object.finish_initializing(builder)
        return new_object

    def finish_initializing(self, builder):
        """Called when we're finished initializing.

        finish_initalizing should be called after parsing the ui definition
        and creating a MonthlyinpaymentDialog object with it in order to
        finish initializing the start of the new MonthlyinpaymentDialog
        instance.
        """
        # Get a reference to the builder and set up the signals.
        self.builder = builder
        self.ui = builder.get_ui(self)
        
        #make toolbar look native
        self.toolbarTop = self.builder.get_object("toolbarTop")
        context = self.toolbarTop.get_style_context()
        context.add_class(Gtk.STYLE_CLASS_PRIMARY_TOOLBAR)
        
        #load tools
        self.tools = Tools.Tools()
        
        
        #for click-events
        self.toolbuttonLogo = self.builder.get_object("toolbuttonLogo")
        
        #elements of dialog for calculation
        self.spinbuttonSavingRate = self.builder.get_object("spinbuttonSavingRate")
        self.spinbuttonDuration = self.builder.get_object("spinbuttonDuration")
        self.spinbuttonRatePerCent = self.builder.get_object("spinbuttonRatePerCent")
        self.comboboxTimeOfInterestCalculation = self.builder.get_object("comboboxTimeOfInterestCalculation")
        self.spinbuttonStartingCapital = self.builder.get_object("spinbuttonStartingCapital")
        self.spinbuttonBlockingPeriod = self.builder.get_object("spinbuttonBlockingPeriod")
        
        
        #elements to set after calculation - Total Results
		self.entryFinalAmount = self.builder.get_object("entryFinalAmount")
		self.entryFinalAmount.set_alignment(0.5)
		self.entryTotalInterest = self.builder.get_object("entryTotalInterest")
        self.entryTotalInterest.set_alignment(0.5)
        self.entryTotalInPayment = self.builder.get_object("entryTotalInPayment")
        self.entryTotalInPayment.set_alignment(0.5)
		self.liststoreDetailedResults = self.builder.get_object("liststoreDetailedResults")   

		#special elements
		self.scrolledwindowTreeView = self.builder.get_object("scrolledwindowTreeView")  

	def on_toolbuttonLogo_clicked(self, widget):
        print "logo clicked"
		#open about dialog
		dlgMluxaboutDialog = MluxaboutDialog.MluxaboutDialog()
		result = dlgMluxaboutDialog.run()
		dlgMluxaboutDialog.destroy()
		
	def on_toolbuttonCalculate_clicked(self, widget):
        print "calculate clicked"
		#leave current focus for including current inputs on calculation
		self.toolbuttonLogo.grab_focus()
		
		self.clear_liststore()
        
        #get input-data
		#get savingrate
		savingrate = self.spinbuttonSavingRate.get_value()
		try:
			float_savingrate = float(savingrate)
		except ValueError:
			float_savingrate = 0
        #get duration
		duration = self.spinbuttonDuration.get_value()
		try:
			int_duration = int(duration)
		except ValueError:
			int_duration = 0
        #get ratepercent
		ratepercent = self.spinbuttonRatePerCent.get_value()
		try:
			float_ratepercent = float(ratepercent)
		except ValueError:
			float_ratepercent = 0
		#optional input-data
		#get startingcapital
		startingcapital = self.spinbuttonStartingCapital.get_value()
		try:
			float_startingcapital = float(startingcapital)
		except ValueError:
			float_startingcapital= 0
		#get blockingperiod
		blockingperiod = self.spinbuttonBlockingPeriod.get_value()
		try:
			int_blockingperiod = int(blockingperiod)
		except ValueError:
			int_blockingperiod = 0
			
			
		#show detailed results
		#y = current year
		y = 1
		total_interest_before = 0
		while(y <= int_duration):	
			#n = duration in months
			n = y*12
			#q = accumulation factor (aufzinsungsfaktor) per month in one year => 12-th sqrt(1+interestrate/100)
			q = (1+(float_ratepercent/100)) ** (1/12.)
			
			inpayments = float_savingrate * 12
			str_inpayments = str(self.tools.formatFloatToStringoutput(format(round(inpayments,2),'.2f')))
			
			#check if starting capital is set
			if self.spinbuttonStartingCapital.get_value() == 0:
				#finaamount = savingrate*((q^n)-1)/(q-1)
				finalamount = float_savingrate * ((q ** n)-1) / (q-1)
			else:
				#finaamount = starting_captital * (1+(percent/100))^cur_year + savingrate*((q^n)-1)/(q-1)
				finalamount = float_startingcapital * pow((1 + (float_ratepercent / 100)), y) + float_savingrate * ((q ** n)-1) / (q-1)
				#same result:
				#finalamount = float_startingcapital * pow(q, n) + float_savingrate * ((q ** n)-1) / (q-1)
			#time of interest calculation: end of month => one more q multiplication
			if self.comboboxTimeOfInterestCalculation.get_active() == 0:
				finalamount = finalamount * q
			
			str_finalamount = str(self.tools.formatFloatToStringoutput(format(round(finalamount,2),'.2f')))	
			
			#check if starting capital is set and first year
			if self.spinbuttonStartingCapital.get_value() != 0 and y == 1:
				#add starting-capital for calculation totalinpayments
				totalinpayments = n * float_savingrate + float_startingcapital
			else:
				totalinpayments = n * float_savingrate

			#total interest = current amount (incl. interests) - total in-payment for current year
			totalinterest = finalamount - totalinpayments
			str_totalinterest = str(self.tools.formatFloatToStringoutput(format(round(totalinterest,2),'.2f')))
			
			
			str_current_interest = str(self.tools.formatFloatToStringoutput(format(round(totalinterest - total_interest_before,2),'.2f')))
			
			#write in list
			self.liststoreDetailedResults.append([str(y), str_current_interest, str_totalinterest, str_inpayments, str_finalamount])
			
			#check if starting capital is set and first year
			#total_interestst_before for calculating current interest for next period
			if self.spinbuttonStartingCapital.get_value() != 0 and y == 1:
				total_interest_before = totalinterest + float_startingcapital
			else:
				total_interest_before = totalinterest
			
			y = y + 1		

		#additional blocking period - normal compound interest calculation
		if self.spinbuttonBlockingPeriod.get_value() != 0:
			float_amount = finalamount
			ya = 1
			total_interest_before = 0
			while(ya <= self.spinbuttonBlockingPeriod.get_value()):
				#compound interest
				#Zinseszins: Endkapital = Anfangskapital * (1 + Zinssatz / 100) ^ Laufzeit
				finalamount = float_amount * pow((1 + (float_ratepercent / 100)), ya)
					
				str_finalamount = str(self.tools.formatFloatToStringoutput(format(round(finalamount,2),'.2f')))	
				str_totalinterest = str(self.tools.formatFloatToStringoutput(format(round(finalamount-float_amount,2),'.2f')))
				
				str_current_interest = str(self.tools.formatFloatToStringoutput(format(round(finalamount-float_amount - total_interest_before,2),'.2f')))
				self.liststoreDetailedResults.append([str(ya + y-1), str_current_interest, str_totalinterest, "0" ,str_finalamount])
				
				total_interest_before = finalamount-float_amount
				ya = ya + 1
			
		
		#str_finalamount = str(self.tools.formatFloatToStringoutput(format(round(finalamount,2),'.2f')))
		totalinpayments = n * float_savingrate + float_startingcapital
		str_totalinpayments = str(self.tools.formatFloatToStringoutput(format(round(totalinpayments,2),'.2f')))
		totalinterest = finalamount - totalinpayments
		str_totalinterest = str(self.tools.formatFloatToStringoutput(format(round(totalinterest,2),'.2f')))
		
		#total results:
		self.entryFinalAmount.set_text(str_finalamount)
		self.entryTotalInPayment.set_text(str_totalinpayments)
		self.entryTotalInterest.set_text(str_totalinterest)
		
		#set outputfiels active
		self.entryFinalAmount.set_sensitive(True)
		self.entryTotalInPayment.set_sensitive(True)
		self.entryTotalInterest.set_sensitive(True)
		
		#set size of treeview and stop on 13 to get the window bigger and bigger
		if int_duration >= 8:
			self.scrolledwindowTreeView.set_min_content_height(192)
		else:
			self.scrolledwindowTreeView.set_min_content_height(26 + (int_duration * 23))
        
	def on_toolbuttonClear_clicked(self, widget):
        print "clear clicked"
        #clear inputs
		self.spinbuttonSavingRate.set_value(0)
        self.spinbuttonDuration.set_value(1)
        self.spinbuttonRatePerCent.set_value(5.00)
        self.comboboxTimeOfInterestCalculation.set_active(0)
        self.spinbuttonStartingCapital.set_value(0)
        self.spinbuttonBlockingPeriod.set_value(0)
		#clear outputs
		self.entryFinalAmount.set_text("")
		self.entryTotalInPayment.set_text("")
		self.entryTotalInterest.set_text("")
		self.clear_liststore()
       
        
	def on_toolbuttonExport_clicked(self, widget):
        print "export clicked"
        #run filechooser-dialog for csv-files
		response, filename = self.tools.fileChooserDialogCSV()
        if response == Gtk.ResponseType.OK:
			if filename[-4:].lower() != ".csv":
				filename = filename + ".csv"
			#get compound-interest-checkbox-value
			timeOfInterestCalculation = ""
			if self.comboboxTimeOfInterestCalculation.get_active() == 0:
				timeOfInterestCalculation = "end_of_month"
			else:
				timeOfInterestCalculation = "begin_of_month"
			#set header
			try:
				csvWriter = csv.writer(open(filename, 'wb'), delimiter=';', quotechar='\'', quoting=csv.QUOTE_MINIMAL)
				csvWriter.writerow(['Year'] +['Interest_($)'] +['Accumulated_Interest_($)'] + ['Contribution_($)'] + ['Total_Capital_($)'] + 
					[''] + ['Monthly_contribution_($):'] + [str(self.tools.formatFloatToStringoutput(format(round(self.spinbuttonSavingRate.get_value(),2),'.2f')))] + 
					[''] + ['Duration_(years):'] + [str(self.tools.formatFloatToStringoutput(format(round(self.spinbuttonDuration.get_value(),2),'.2f')))] + 
					[''] +['Yearly_interest_rate_(%):'] + [str(self.tools.formatFloatToStringoutput(format(round(self.spinbuttonRatePerCent.get_value(),2),'.2f')))] +
					[''] + ['Calculate_interest_at:'] + [timeOfInterestCalculation] +
					[''] + ['Starting_amount_($):'] + [str(self.tools.formatFloatToStringoutput(format(round(self.spinbuttonStartingCapital.get_value(),2),'.2f')))] +
					[''] + ['Additional_blocking_period_(years):'] + [str(self.tools.formatFloatToStringoutput(format(round(self.spinbuttonBlockingPeriod.get_value(),2),'.2f')))])
				#fill with table-inputs
				for row in self.liststoreDetailedResults:
					csvWriter.writerow([row[0]] +[row[1]] +[row[2]] + [row[3]] + [row[4]])
				#systemnotification if csv-file correctly saved on filesystem
				self.tools.showSystemNotification('CSV-Export', 
					'The CSV-File was created successfully!\nYou will find the file on: \n\"' + filename + '\"',
					 'document-save')
			except IOError:
				print "exception: IO Error occured"
				self.tools.showSystemNotification('Error on CSV-Export', 'The CSV-File was not created!\nAn error occured. Maybe you have insufficient privileges on this location to write the file:\n"'
					+ filename + '\"','dialog-error')
        
	def clear_liststore(self):
		#clear list and resize window to minimum
		self.liststoreDetailedResults.clear()
		self.resize(1,1)
		self.scrolledwindowTreeView.set_min_content_height(1)
		#set outputfiels inactive
		self.entryFinalAmount.set_sensitive(False)
		self.entryTotalInPayment.set_sensitive(False)
		self.entryTotalInterest.set_sensitive(False)
		
		
if __name__ == "__main__":
    dialog = MonthlyinpaymentDialog()
    dialog.show()
    Gtk.main()
