# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Marian Lux marian.lux@mlux.at
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import locale
from locale import gettext as _
locale.textdomain('interest-calculation')

from gi.repository import Gtk # pylint: disable=E0611
import logging
logger = logging.getLogger('interest_calculation')

from interest_calculation_lib import Window
from interest_calculation.AboutInterestCalculationDialog import AboutInterestCalculationDialog

import commands

#own classes
import PaymentinadvanceDialog
import MonthlyinpaymentDialog
import AnnuityloanDialog
#import Constants


# See interest_calculation_lib.Window.py for more details about how this class works
class InterestCalculationWindow(Window):
    __gtype_name__ = "InterestCalculationWindow"
    
    def finish_initializing(self, builder): # pylint: disable=E1002
        """Set up the main window"""
        super(InterestCalculationWindow, self).finish_initializing(builder)

        self.AboutDialog = AboutInterestCalculationDialog

        # Code for other initialization actions should be added here.
        
        #make toolbar look native
        self.toolbar = self.builder.get_object("toolbar")
        context = self.toolbar.get_style_context()
        context.add_class(Gtk.STYLE_CLASS_PRIMARY_TOOLBAR)
        
		
        self.toolbuttonLogo = self.builder.get_object("toolbuttonLogo")
        self.mnu_about = self.builder.get_object("mnu_about")
        self.mnu_contents = self.builder.get_object("mnu_contents")
        self.buttonExit = self.builder.get_object("buttonExit")
        
		#load constants
		#self.constants = Constants.Constants()
        

    def on_toolbuttonLogo_clicked(self, widget):
        print "logo clicked"
        #disply aboutbox: call signal "activate" for the menu-item (is listed on signals in glade) 
        self.mnu_about.activate()
        #open standard browser with mlux.at wehn logo clicked
		#commands.getstatusoutput(self.constants.callHomepageString)
        
    def on_buttonExit_clicked(self, widget):
        print "exit clicked"
        #exit application
		self.destroy();
		
	def on_toolbuttonPaymentInAdvance_clicked(self, widget):
        print "on_toolbuttonPaymentInAdvance_clicked"
        dlgPaymentInAdvance = PaymentinadvanceDialog.PaymentinadvanceDialog()
        self.hide();
        result = dlgPaymentInAdvance.run()
        dlgPaymentInAdvance.destroy()
        self.show();
		
	def on_toolbuttonMonthlyInPayment_clicked(self, widget):
        print "on_toolbuttonMonthlyInPayment_clicked"
        dlgMonthlyInPayment = MonthlyinpaymentDialog.MonthlyinpaymentDialog()
        self.hide();
        result = dlgMonthlyInPayment.run()
        dlgMonthlyInPayment.destroy()
        self.show();

	def on_toolbuttonAnnuityLoan_clicked(self, widget):
        print "on_toolbuttonAnnuityLoan_clicked"
        dlgAnnuityLoan = AnnuityloanDialog.AnnuityloanDialog()
        self.hide();
        result = dlgAnnuityLoan.run()
        dlgAnnuityLoan.destroy()
        self.show();
        
	def on_toolbuttonLogoSelection_clicked(self, widget):
		print "on_toolbuttonLogoSelection_clicked"
		#disply index.page: call signal "activate" for the menu-item (is listed on signals in glade) 
        self.mnu_contents.activate()
        
