# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Marian Lux marian.lux@mlux.at
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from gi.repository import Gtk # pylint: disable=E0611

from interest_calculation_lib.helpers import get_builder

import locale
from locale import gettext as _
locale.textdomain('interest-calculation')

import commands
import math
import csv

#own classes
import Tools
import MluxaboutDialog

class AnnuityloanDialog(Gtk.Dialog):
    __gtype_name__ = "AnnuityloanDialog"

    def __new__(cls):
        """Special static method that's automatically called by Python when 
        constructing a new instance of this class.
        
        Returns a fully instantiated AnnuityloanDialog object.
        """
        builder = get_builder('AnnuityloanDialog')
        new_object = builder.get_object('annuityloan_dialog')
        new_object.finish_initializing(builder)
        return new_object

    def finish_initializing(self, builder):
        """Called when we're finished initializing.

        finish_initalizing should be called after parsing the ui definition
        and creating a AnnuityloanDialog object with it in order to
        finish initializing the start of the new AnnuityloanDialog
        instance.
        """
        # Get a reference to the builder and set up the signals.
        self.builder = builder
        self.ui = builder.get_ui(self)

		#make toolbar look native
        self.toolbarTop = self.builder.get_object("toolbarTop")
        context = self.toolbarTop.get_style_context()
        context.add_class(Gtk.STYLE_CLASS_PRIMARY_TOOLBAR)
        
		#load tools
		self.tools = Tools.Tools()
		
		#for click-events
		self.toolbuttonLogo = self.builder.get_object("toolbuttonLogo")
		
		#elements of dialog for calculation
        self.spinbuttonAmount = self.builder.get_object("spinbuttonAmount")
        self.spinbuttonDuration = self.builder.get_object("spinbuttonDuration")
        self.spinbuttonRatePerCent = self.builder.get_object("spinbuttonRatePerCent")
				
		#elements to set after calculation - Total Results
		self.entryAnnualPaymentYear = self.builder.get_object("entryAnnualPaymentYear")
		self.entryAnnualPaymentYear.set_alignment(0.5)
		self.entryAnnualPaymentMonth = self.builder.get_object("entryAnnualPaymentMonth")
		self.entryAnnualPaymentMonth.set_alignment(0.5)
		self.entryTotalInterest = self.builder.get_object("entryTotalInterest")
		self.entryTotalInterest.set_alignment(0.5)
		self.liststoreDetailedResults = self.builder.get_object("liststoreDetailedResults")  
		
		#special elements
		self.scrolledwindowTreeView = self.builder.get_object("scrolledwindowTreeView")   		
		

	def on_toolbuttonLogo_clicked(self, widget):
		print "logo clicked"
		#open about dialog
		dlgMluxaboutDialog = MluxaboutDialog.MluxaboutDialog()
		result = dlgMluxaboutDialog.run()
		dlgMluxaboutDialog.destroy()
	
	def on_toolbuttonCalculate_clicked(self, widget):
		print "calculate clicked"	
		#leave current focus for including current inputs on calculation
		self.toolbuttonLogo.grab_focus()
		
		self.clear_liststore()
	
		#get input-data
		#get amount
		residualdebt = self.spinbuttonAmount.get_value()
		try:
			float_residualdebt = float(residualdebt)
		except ValueError:
			float_residualdebt = 0
        #get duration
        duration = self.spinbuttonDuration.get_value()
		try:
			int_duration = int(duration)
		except ValueError:
			int_duration = 0
		#get ratepercent
		ratepercent = self.spinbuttonRatePerCent.get_value()
		try:
			float_ratepercent = float(ratepercent)
		except ValueError:
			float_ratepercent = 0
		#calculate results:
		#q = accumulation factor = 1 + rate/100
		q = 1 + ratepercent/100
		#annuity per year = amount(credit) * q^duration * (q-1) / (q^duration -1) 
		annualpaymentyear = float_residualdebt * pow(q,duration) * ((q-1) / (pow(q,duration)-1))
		
		str_annualpaymentyear = str(self.tools.formatFloatToStringoutput(format(round(annualpaymentyear,2),'.2f')))	
		str_annualpaymentmonth = str(self.tools.formatFloatToStringoutput(format(round(annualpaymentyear / 12,2),'.2f')))
		
		#total results:
		self.entryAnnualPaymentYear.set_text(str_annualpaymentyear)
		self.entryAnnualPaymentMonth.set_text(str_annualpaymentmonth)
		
		#show detailed results
		y = 1
		residualdebt_before = float_residualdebt
		totalinterest = 0
		while(y <= int_duration):
			str_residualDebtBeginOfYear = str(self.tools.formatFloatToStringoutput(format(round(residualdebt_before,2),'.2f')))	
			interest = float_ratepercent * (residualdebt_before / 100)
			totalinterest = totalinterest + interest
			str_interest = str(self.tools.formatFloatToStringoutput(format(round(interest,2),'.2f')))
			str_repayment = str(self.tools.formatFloatToStringoutput(format(round(annualpaymentyear - interest,2),'.2f')))
			str_residualDebtEndOfYear = str(self.tools.formatFloatToStringoutput(format(round(residualdebt_before - (annualpaymentyear - interest),2),'.2f')))	
			self.liststoreDetailedResults.append([str(y), str_residualDebtBeginOfYear, str_interest, str_repayment, str_annualpaymentyear, str_residualDebtEndOfYear])
			
			residualdebt_before = residualdebt_before - (annualpaymentyear - interest)
			y = y + 1
		
		#total results:
		str_totalinterest = str(self.tools.formatFloatToStringoutput(format(round(totalinterest,2),'.2f')))
		self.entryTotalInterest.set_text(str_totalinterest)
		
		#set outputfiels active
		self.entryAnnualPaymentYear.set_sensitive(True)
		self.entryAnnualPaymentMonth.set_sensitive(True)
		self.entryTotalInterest.set_sensitive(True)
		
		#set size of treeview and stop on 13 to get the window bigger and bigger
		if int_duration >= 9:
			self.scrolledwindowTreeView.set_min_content_height(238)
		else:
			self.scrolledwindowTreeView.set_min_content_height(26 + (int_duration * 23))

	
	def on_toolbuttonClear_clicked(self, widget):
		print "clear clicked"
		#clear inputs
		self.spinbuttonAmount.set_value(0)
		self.spinbuttonDuration.set_value(1)
		self.spinbuttonRatePerCent.set_value(5.00)
		#clear outputs
		self.entryAnnualPaymentYear.set_text("")
		self.entryAnnualPaymentMonth.set_text("")
		self.entryTotalInterest.set_text("")
		self.clear_liststore()
	
	def on_toolbuttonExport_clicked(self, widget):
		print "export clicked"
		#run filechooser-dialog for csv-files
		response, filename = self.tools.fileChooserDialogCSV()
		if response == Gtk.ResponseType.OK:
			if filename[-4:].lower() != ".csv":
				filename = filename + ".csv"
			#set header
			try:
				csvWriter = csv.writer(open(filename, 'wb'), delimiter=';', quotechar='\'', quoting=csv.QUOTE_MINIMAL)
				csvWriter.writerow(['Year'] +['Residual_Debt_Begin_of_Year_($)'] +['Interest_($)'] + ['Loan_Repayment_($)'] + ['Annual_Payment_($)'] + ['Residual_Debt_End_of_Year_($)'] +
					[''] + ['Loan_amount_($):'] + [str(self.tools.formatFloatToStringoutput(format(round(self.spinbuttonAmount.get_value(),2),'.2f')))] + 
					[''] + ['Duration_(years):'] + [str(self.tools.formatFloatToStringoutput(format(round(self.spinbuttonDuration.get_value(),2),'.2f')))] + 
					[''] +['Rate_percent_(%):'] + [str(self.tools.formatFloatToStringoutput(format(round(self.spinbuttonRatePerCent.get_value(),2),'.2f')))])
				#fill with table-inputs
				for row in self.liststoreDetailedResults:
					csvWriter.writerow([row[0]] +[row[1]] +[row[2]] + [row[3]] + [row[4]] + [row[5]])
				#systemnotification if csv-file correctly saved on filesystem
				self.tools.showSystemNotification('CSV-Export', 
					'The CSV-File was created successfully!\nYou will find the file on: \n\"' + filename + '\"',
					 'document-save')
			except IOError:
				print "exception: IO Error occured"
				self.tools.showSystemNotification('Error on CSV-Export', 'The CSV-File was not created!\nAn error occured. Maybe you have insufficient privileges on this location to write the file:\n"'
					+ filename + '\"','dialog-error')		
		
	def clear_liststore(self):
		#clear list and resize window to minimum
		self.liststoreDetailedResults.clear()
		self.resize(1,1)
		self.scrolledwindowTreeView.set_min_content_height(1)
		#set outputfiels inactive
		self.entryAnnualPaymentYear.set_sensitive(False)
		self.entryAnnualPaymentMonth.set_sensitive(False)
		self.entryTotalInterest.set_sensitive(False)


if __name__ == "__main__":
    dialog = AnnuityloanDialog()
    dialog.show()
    Gtk.main()
