from datetime import date, time, datetime, timedelta
from dateutil import parser

"""def parse_date(d):
	today = date.today()
	format = "%m/%d/%Y"

	days = ["monday", "tuesday", "wednesday", "thursday", "friday", "saturday",
		"sunday", "mon", "tues", "wed", "thurs", "fri", "sat", "sun"]
	other_days = ["today", "tomorrow", "tom"]
	other = ["days", "from"]
	first_only = ["next", "nx", "every", "ev"]
	second_only = ["weekday", "weekend", "other", "day"]

	if d == "" or d == None:
		d = "today"

	dl = d.split()
	if len(dl) == 1:
		#either a number or a day or a date
		try:
			parser.parse(d)
		except ValueError:
			#invalid
			if d not in other_days and d not in days: #ex: tomorrow, mon
				return None

		if d.isdigit(): #ex: 5
			d2 = today + timedelta(int(d))
			return d2.strftime(format)
		elif d in days or d in other_days: #ex: monday, tom
			return parse_day(d)
		elif len(d) == 1 and not d.isdigit():
			return None
		else: #ex: 7/12/2012
			return parser.parse(d).strftime(format)
	else:
		if dl[0] not in first_only:
			try:
				return parser.parse(d).strftime(format)
			except ValueError:
				return None
		if dl[1] not in second_only and dl[1] not in days and not dl[1].isdigit():
			return None
		if len(dl) > 2 and dl[2] not in other:
			return None
		if len(dl) > 3:
			try:
				parser.parse(dl[3])
				if dl[3].isdigit():
					d2 = today + timedelta(int(dl[3]))
					d = d.replace(dl[3], d2.strftime(format))

			except ValueError:
				if len(dl) > 4 and dl[3] in other:
					try:
						parser.parse(dl[4])
						if dl[4].isdigit():
							d2 = today + timedelta(int(dl[4]))
							d = d.replace(dl[4], d2.strftime(format))

					except ValueError:
						return None
				else:
					return None
		if len(dl) > 2 and dl[1].isdigit() and dl[2] == "from":
			return None

		d = d.replace("ev ", "every ")
		d = d.replace("nx ", "next ")

		if "monday" not in d:
			d = d.replace("mon", "monday")
		elif "tuesday" not in d:
			d = d.replace("tues", "tuesday")
		elif "wednesday" not in d:
			d = d.replace("wed", "wednesday")
		elif "thursday" not in d:
			d = d.replace("thurs", "thursday")
		elif "friday" not in d:
			d = d.replace("fri", "friday")
		elif "saturday" not in d:
			d = d.replace("sat", "saturday")
		elif "sunday" not in d:
			d = d.replace("sun", "sunday")

		if d == "every other":
			d += " from " + today.strftime(format)
		if len(dl) == 3 and dl[0] == "every" and dl[2] == "days":
			d += " from " + today.strftime(format)
		if len(dl) == 2 and dl[0] == "next" and dl[1].isdigit():
			if int(dl[1]) >= today.day:
				return parser.parse(dl[1]).strftime(format)
			else:
				d2 = parser.parse(dl[1]) + timedelta(month=1)
				return d2.strftime(format)
		#if len(dl) == 2 and dl[0] == "every" and dl[1].isdigit():
			#d += " from " + today.strftime(format)
		if len(dl) == 3 and dl[0] == "next" and dl[2] == "days":
			d += " from " + today.strftime(format)

		if d.lower() == "next monday":
			d2 = parser.parse("monday") + timedelta(days=7)
			return d2.strftime(format)
		elif d.lower() == "next tuesday":
			d2 = parser.parse("tuesday") + timedelta(days=7)
			return d2.strftime(format)
		elif d.lower() == "next wednesday":
			d2 = parser.parse("wednesday") + timedelta(days=7)
			return d2.strftime(format)
		elif d.lower() == "next thursday":
			d2 = parser.parse("thursday") + timedelta(days=7)
			return d2.strftime(format)
		elif d.lower() == "next friday":
			d2 = parser.parse("friday") + timedelta(days=7)
			return d2.strftime(format)
		elif d.lower() == "next saturday":
			d2 = parser.parse("saturday") + timedelta(days=7)
			return d2.strftime(format)
		elif d.lower() == "next sunday":
			d2 = parser.parse("sunday") + timedelta(days=7)
			return d2.strftime(format)

		return d

def parse_day(d):
	today = date.today()
	format = "%m/%d/%Y"

	if d.lower() == "today":
		return today.strftime(format)
	elif d.lower() == "tomorrow" or d.lower() == "tom":
		tom = today + timedelta(1)
		return tom.strftime(format)
	elif d.lower() == "monday" or d.lower() == "mon":
		d2 = parser.parse("monday")
		return d2.strftime(format)
	elif d.lower() == "tuesday" or d.lower() == "tues":
		d2 = parser.parse("tuesday")
		return d2.strftime(format)
	elif d.lower() == "wednesday" or d.lower() == "wed":
		d2 = parser.parse("wednesday")
		return d2.strftime(format)
	elif d.lower() == "thursday" or d.lower() == "thurs":
		d2 = parser.parse("thursday")
		return d2.strftime(format)
	elif d.lower() == "friday" or d.lower() == "fri":
		d2 = parser.parse("friday")
		return d2.strftime(format)
	elif d.lower() == "saturday" or d.lower() == "sat":
		d2 = parser.parse("saturday")
		return d2.strftime(format)
	elif d.lower() == "sunday" or d.lower() == "sun":
		d2 = parser.parse("sunday")
		return d2.strftime(format)
	else:
		return None

valid = ["", "7/12/2012", "7-12-12", "today", "tom", "monday", "mon", "next monday",
	"nx mon", "every monday", "ev mon", "every day", "every 30",
	"every 30 days", "every 30 days from 7/12/12", "July 12 2012", "Jul 12", "5",
	"every weekday", "every weekend", "every other", "every other from 7/12/2012",
	"every other from 5", "every 30 days from 5", "next 30", "next 30 days"]

invalid = ["asdf", "532asdf", "every asdf", "nx asdf", "monday tomorrow", "tomorrow every",
	"every 30 from asdf", "every 30 asdf", "every 30 days from asdf", "every 30 from 7/12/12",
	"every 30 from", "m"]

print "testing valid"
counter = 0
for v in valid:
	print "testing string: " + v
	print parse_date(v)
	counter += 1

print "testing invalid"
for i in invalid:
	print "testing string: " + i
	print parse_date(i)"""

def parse_date(t, d):
	try:
		parser.parse(d) #no need to format
	except ValueError:
		dl = d.split()
		today = date.today()
		format = "%m/%d/%Y"
		if dl[0] == "every":
			days = ["monday", "tuesday", "wednesday", "thursday", "friday",
				"saturday","sunday"]
			if dl[1] in days:
				d = dl[1] #ex: monday
			elif dl[1] == "weekday":
				w = int(today.strftime("%w"))
				if w is not 0 and w is not 6: #today is weekday
					d = today.strftime(format)
				else: #today is weekend
					d = "monday"
			elif dl[1] == "weekend":
				w = int(today.strftime("%w"))
				if w is not 0 and w is not 6: #today is weekday
					d = "saturday"
				else: #today is weekend
					d = today.strftime(format)
			elif dl[1] == "day":
				d = today.strftime("%m/%d/%Y")
			elif dl[1].isdigit() and len(dl) == 2:
				d = parser.parse(dl[1]).strftime(format)
			elif dl[1] == "other":
				d = parser.parse(dl[3]).date()
				while d < today:
					d += timedelta(days=2)
				d = d.strftime(format)
			elif dl[0] == "every" and dl[2] == "days":
				d = parser.parse(dl[4]).date()
				while d < today:
					d += timedelta(days=int(dl[1]))
				d = d.strftime(format)
		else: #dl[0] == "next"
			d = parser.parse(dl[4]).date()
			d2 = d + timedelta(days=int(dl[1]))
			if d <= today and d2 >= today:
				d = today.strftime(format)
			else:
				d = d.strftime(format)

	p = d
	if t is not None:
		p = t + " " + d
	return parser.parse(p)

test = ["07/04/2012", "every monday", "every weekday", "every weekend", "every day",
	"every 1", "every other from 07/02/2012",
	"every 30 days from 07/01/2012", "next 30 days from 07/01/2012"]

for t in test:
	print "testing string: " + t
	print parse_date(None, t)