#!/usr/bin/python
# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Brian Douglass bhdouglass@gmail.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

"""Code to add AppIndicator."""

from gi.repository import Gtk # pylint: disable=E0611
from gi.repository import AppIndicator3 # pylint: disable=E0611

from indicator_remindor_lib.helpers import get_media_file

import gettext
from gettext import gettext as _
gettext.textdomain('indicator-remindor')

class Indicator:
    def __init__(self, window):
        self.indicator = AppIndicator3.Indicator.new('indicator-remindor', '', AppIndicator3.IndicatorCategory.APPLICATION_STATUS)
        self.indicator.set_status(AppIndicator3.IndicatorStatus.ACTIVE)

        icon_uri = get_media_file("indicator-remindor.svg")
        icon_path = icon_uri.replace("file:///", '')
        self.indicator.set_icon(icon_path)

        #Uncomment and choose an icon for attention state.
        #self.indicator.set_attention_icon("ICON-NAME")

        self.menu = Gtk.Menu()

        # Add items to Menu and connect signals.
        #self.add = Gtk.MenuItem("Add")
        self.add = Gtk.ImageMenuItem(Gtk.STOCK_ADD)
        self.add.set_use_stock(True)
        self.add.set_label("Add")
        self.add.connect("activate", window.on_add_clicked)
        self.add.show()
        self.menu.append(self.add)

        self.quick = Gtk.ImageMenuItem(Gtk.STOCK_MEDIA_FORWARD)
        self.quick.set_use_stock(True)
        self.quick.set_label("Quick Add")
        self.quick.connect("activate", window.on_quick_add_clicked)
        self.quick.show()
        self.menu.append(self.quick)

        self.stop = Gtk.ImageMenuItem(Gtk.STOCK_MEDIA_STOP)
        self.stop.set_use_stock(True)
        self.stop.set_label("Stop Sound")
        self.stop.connect("activate", window.stop_sound)
        self.stop.show()
        self.menu.append(self.stop)

        self.manage = Gtk.ImageMenuItem(Gtk.STOCK_PREFERENCES)
        self.manage.set_use_stock(True)
        self.manage.set_label("Manage")
        self.manage.connect("activate", window.on_indicator_manage_activate)
        self.manage.show()
        self.menu.append(self.manage)

        #self.sync = Gtk.ImageMenuItem(Gtk.STOCK_CONNECT)
        #self.sync.set_use_stock(True)
        #self.sync.set_label("Sync")
        #self.sync.set_tooltip_text("Sync alarms with Ubuntu One")
        #self.sync.connect("activate", window.on_indicator_sync_activate)
        #self.sync.show()
        #self.menu.append(self.sync)

        #self.preferences = Gtk.MenuItem("Preferences")
        #self.preferences.connect("activate", window.on_mnu_preferences_activate)
        #self.preferences.show()
        #self.menu.append(self.preferences)

        self.quit = Gtk.ImageMenuItem(Gtk.STOCK_QUIT)
        self.quit.set_use_stock(True)
        self.quit.set_label("Quit")
        self.quit.connect("activate", window.on_indicator_quit_activate)
        self.quit.show()
        self.menu.append(self.quit)

        # Add more items here

        self.menu.show()
        self.indicator.set_menu(self.menu)

def new_application_indicator(window):
    ind = Indicator(window)
    return ind.indicator
