# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Brian Douglass bhdouglass@gmail.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from gi.repository import Gtk, GObject # pylint: disable=E0611

from datetime import timedelta, datetime
from dateutil import parser
from desktopcouch.records.server import CouchDatabase
from desktopcouch.records.record import Record

from indicator_remindor_lib.helpers import get_builder

import gettext
from gettext import gettext as _
gettext.textdomain('indicator-remindor')

class QuickDialog(Gtk.Dialog):
    __gtype_name__ = "QuickDialog"
    __gsignals__ = {
		'alarm_added' : (GObject.SIGNAL_RUN_LAST, GObject.TYPE_NONE,
			(GObject.TYPE_STRING,))
	}

    def __new__(cls):
        """Special static method that's automatically called by Python when
        constructing a new instance of this class.

        Returns a fully instantiated QuickDialog object.
        """
        builder = get_builder('QuickDialog')
        new_object = builder.get_object('quick_dialog')
        new_object.finish_initializing(builder)
        return new_object

    def finish_initializing(self, builder):
        """Called when we're finished initializing.

        finish_initalizing should be called after parsing the ui definition
        and creating a QuickDialog object with it in order to
        finish initializing the start of the new QuickDialog
        instance.
        """
        # Get a reference to the builder and set up the signals.
        self.builder = builder
        self.ui = builder.get_ui(self)

        label_object = self.builder.get_object("label_entry")
        label_object.connect('icon-release', self.label_clear)

	def label_clear(self, widget, pos, event, data=None):
		label_object = self.builder.get_object("label_entry")
		label_object.set_text("")

    def on_btn_add_clicked(self, widget, data=None):
        """The user has elected to save the changes.

        Called before the dialog returns Gtk.ResponseType.OK from run().
        """

		label_object = self.builder.get_object("label_entry")
		label = label_object.get_text()

		minutes_object = self.builder.get_object("minutes_entry")
		minutes = minutes_object.get_value()

		now = datetime.now() + timedelta(minutes=minutes)
		date = now.strftime("%m/%d/%Y")
		hour = now.hour
		am_pm = 0
		if hour > 12:
			hour -= 12
			am_pm = 1

		db = CouchDatabase('indicator-remindor-alarms', create=True)

		rec = Record({
			"label" : label,
			"notes" : "",
			"hour" : hour,
			"minute" : now.minute,
			"am_pm" : am_pm,
			"date" : date,
			"sound" : None,
			"notification" : True,
			"command" : ""
		}, record_type='http://wiki.ubuntu.com/Quickly/RecordTypes/IndicatorRemindor/')
		r = db.put_record(rec)

		self.emit('alarm_added', r)

        pass

    def on_btn_cancel_clicked(self, widget, data=None):
        """The user has elected cancel changes.

        Called before the dialog returns Gtk.ResponseType.CANCEL for run()
        """
        pass


if __name__ == "__main__":
    dialog = QuickDialog()
    dialog.show()
    Gtk.main()
