# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Jobi Kea Carter keacarterdev@gmail.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE
import gettext
from gettext import gettext as _
gettext.textdomain('flashgen')

from gi.repository import Gtk, Gio # pylint: disable=E0611
from gi.repository import Notify
import logging
logger = logging.getLogger('flashgen')

import os, os.path

from flashgen_lib import Window
from flashgen_lib import edict
e = edict.edict()

from flashgen.AboutFlashgenDialog import AboutFlashgenDialog
from flashgen.PreferencesFlashgenDialog import PreferencesFlashgenDialog

class GenerateOutput(Gtk.Dialog):
	
    def __init__(self,parent,output_dir,filename):
		'''returns the filename and output dir of the users choice'''
		self.create_output = True #used in main window to see if should run output
		self.filename = filename
		self.output_dir = output_dir
		self.chooser = Gtk.FileChooserDialog('test title',None,
		Gtk.FileChooserAction.SELECT_FOLDER,
		buttons=(
			Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL,
			Gtk.STOCK_OK,Gtk.ResponseType.OK))
		self.chooser.set_filename(self.output_dir)
        Gtk.Dialog.__init__(self, "Output Information", parent, 0,),
		chooser_button = Gtk.Button('Select folder')
		chooser_button.connect("clicked", self.set_output_dir)
        cancel_button = Gtk.Button('Cancel')
        generate_button = Gtk.Button('Generate File')
        generate_button.connect("clicked", self.generate)
        cancel_button.connect("clicked", self.cancel)
        
        self.set_default_size(225, 100)
        
        self.filename_entry= Gtk.Entry()
		self.filename_entry.set_text(self.filename)
        box = self.get_content_area()
        hbox = Gtk.HBox()
        hbox.pack_start(Gtk.Label("Output Directory:"), False, 5, 5)
		hbox.pack_end(chooser_button, False, 5, 5)
        hbox2 = Gtk.HBox()
        hbox2.pack_start(Gtk.Label("Filename:"), False, 5, 5)
		hbox2.pack_end(self.filename_entry, False, 5, 5)
        blank_label = Gtk.Label(' ')
        blank_label2 = Gtk.Label(' ')
        hboxblank = Gtk.HBox()
        hboxblank.pack_start(blank_label,False,5,5)
        hboxblank.pack_end(blank_label2,False,5,5)
        hbox3 = Gtk.HBox()
        hbox3.pack_start(cancel_button, False, 5, 5)
		hbox3.pack_end(generate_button, False, 5, 5)
        box.add(hbox)
        box.add(hbox2)
		box.add(hboxblank)
        box.add(hbox3)
        self.show_all()
	
	def set_output_dir(self, widget, data=None):
		response = self.chooser.run()
		if response == Gtk.ResponseType.OK:
			self.output_dir = self.chooser.get_filename()
		self.chooser.hide()

	def cancel(self,parent):
		 self.create_output = False
		 self.destroy()
	
	def generate(self,parent):
		 self.filename = self.filename_entry.get_text()
		 self.destroy()
		 

class EmptyGenerate(Gtk.Dialog):

    def __init__(self, parent):
		
        Gtk.Dialog.__init__(self, "Nothing to Generate", parent, 0,
            (Gtk.STOCK_OK, Gtk.ResponseType.OK))

        self.set_default_size(225, 100)
        label = Gtk.Label("\nNothing to generate!\n\nMake sure you have added\ncontent to your final list\n by \"committing\" it.\n")
        box = self.get_content_area()
        box.add(label)
        self.show_all()

class DuplicatesCommit(Gtk.Dialog):

    def __init__(self, parent,tab):
		
        Gtk.Dialog.__init__(self, "Duplicates Detected", parent, 0,
            (
             Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL,
             Gtk.STOCK_YES, Gtk.ResponseType.YES,
             Gtk.STOCK_NO, Gtk.ResponseType.NO))

        self.set_default_size(150, 100)
        label = Gtk.Label("\nDuplicate definitions have been\ndectected when adding from\n the " + tab +" tab.\n\nDo you want to add these\nduplicates to your final list?\n")
        box = self.get_content_area()
        box.add(label)
        self.show_all()

class Continue(Gtk.Dialog):

    def __init__(self, parent):

        Gtk.Dialog.__init__(self, "Continue?", parent, 0,
            (Gtk.STOCK_YES, Gtk.ResponseType.YES,
             Gtk.STOCK_NO, Gtk.ResponseType.NO))

        self.set_default_size(150, 100)
        label = Gtk.Label("\nAre you sure you want\n to remove everything?")
        box = self.get_content_area()
        box.add(label)
        self.show_all()
             
# See flashgen_lib.Window.py for more details about how this class works'
class FlashgenWindow(Window):
    __gtype_name__ = "FlashgenWindow"
    
    def finish_initializing(self, builder): # pylint: disable=E1002
        """Set up the main window"""
		super(FlashgenWindow, self).finish_initializing(builder)
		
		#notify init
		Notify.init('FlashGen')
		
		
        #make sure config dir exists, just in case 
        confdir = os.getenv("HOME") +'/.config/'
        if not os.path.exists(confdir):
			os.mkdir(confdir)
        #check if flashgen dir exists, and make it if not
        flashgen_db_dir = os.getenv("HOME") +'/.config/flashgen/'
        eng_dic =  flashgen_db_dir + 'eng_dic'
        kanji_dic =  flashgen_db_dir + 'kanji_dic'
        if os.path.exists(flashgen_db_dir):
			pass
		else:
			os.mkdir(flashgen_db_dir)
		#check if both DB exist, and create if not
		if os.path.exists(eng_dic) and os.path.exists(kanji_dic):
			pass
		else: 
			import shelve
			#notify of creation
			db_notification = Notify.Notification.new(
			'Generating Dictionaries',
			'FlashGen is currently generating your dictionaries, and will automatically open when done. This process can take some time, so go have fun!',
			None)
			db_notification.show ()
			#creation
			from flashgen_lib import edictsource
			es = edictsource.EdictSource()
			eng_dic_db = shelve.open(eng_dic,writeback=True) #create dic file
			kanji_dic_db = shelve.open(kanji_dic,writeback=True) #create dic file
			e.make_dictionaries(es.edict_body.split('\n'),flashgen_db_dir,eng_dic_db,kanji_dic_db)
			#notify of completion
			db_done_notification = Notify.Notification.new(
			'Dictionary Generation Complete',
			'The dictionaries were created successfully, enjoy your studies!',
			None)
			db_done_notification.show ()
		
		#tell edict to use default dictionaries
		e.set_db_directory(eng_dic,kanji_dic)
		
		#make sure db are complete via searching for last string to be added to dic. 
		if e.search('遙遙'): 
			#databases are set up correctly, so continue on to the program
			pass
		else:#db are not correct, exit, possibly generating now
			db_notification_fail = Notify.Notification.new(
			'Problem with Dictionaries',
			'It looks like your dictionaries are not set up yet, or are corrupted. It is possible there is another FlashGen instance creating them right now, so please wait for 10 to 20 minutes and try again. If it continues to be a problem, run "rm -R ~/.config/flashgen", and then try again.',
			None)
			db_notification_fail.show ()
			import sys
			sys.exit()
        
        #other dialogs
        self.AboutDialog = AboutFlashgenDialog
        self.PreferencesDialog = PreferencesFlashgenDialog
        
		#import preferences and set local preference variables
		self.settings = Gio.Settings("net.launchpad.flashgen")
		
		#set output and filename preferences
		if self.settings.get_string("outputdir"):
			self.output_dir = self.settings.get_string("outputdir")
			if not os.path.exists(self.output_dir):
				bad_output_dir_notification = Notify.Notification.new(
				'Invalid Output Directory',
				'The "Default Output Directory" you have set in the preferences is invalid. Please change it to something valid and restart FlashGen, or you may have problems generating files.',
				None)
				bad_output_dir_notification.show ()
				
		else:
			self.output_dir = os.getenv('HOME')
		self.filename = self.settings.get_string("filename")
		if not self.filename:
			self.filename = 'FlashgenCards'
		#set commit preferences
		if self.settings.get_boolean("commitprompt"):
			self.commit_dialog = True
		else:
			self.commit_dialog = False
		if self.settings.get_boolean("commitalways"):
			self.commit_duplicates = True
		elif self.settings.get_boolean("commitnever"):
			self.commit_duplicates = False
        
        #set confirm on remove preferences
		self.confirm_on_remove = self.settings.get_boolean("removeconfirmalways")
        
        #set prompt_on_generate
        self.prompt_on_generate = self.settings.get_boolean("generatepromptalways")
        
        # Code for other initialization actions should be added here.
	
		#UI objects
		
		######################### Applies to all tabs #########################
		#create tree iter
		self.iter = Gtk.TreeModel
		#renderer for treeviews
		renderer = Gtk.CellRendererText()
		#set renderer sresults toggle
		renderer_toggle_sresults = Gtk.CellRendererToggle()
        #set renderer toggle connect
        renderer_toggle_sresults.connect("toggled", self.on_cell_toggled_sresults)
        #render for sadd
        #set renderer sadd toggle
		renderer_toggle_sadd = Gtk.CellRendererToggle()
        #set renderer sadd toggle connect
        renderer_toggle_sadd.connect("toggled", self.on_cell_toggled_sadd)
        #render for o
        #set renderer sadd toggle
		renderer_toggle_o = Gtk.CellRendererToggle()
        #set renderer sadd toggle connect
        renderer_toggle_o.connect("toggled", self.on_cell_toggled_o)
        #render for afs
        #set renderer sadd toggle
		renderer_toggle_afs = Gtk.CellRendererToggle()
        #set renderer sadd toggle connect
        renderer_toggle_afs.connect("toggled", self.on_cell_toggled_afs)
        
		######################### Add From Search Tab #########################
		#search field and go button
		self.search_field = self.builder.get_object('search_field')
		self.search_go = self.builder.get_object('search_go')
		#search results (sresults) treeview and liststore
		self.sresults = self.builder.get_object('sresult_liststore')
		self.sresults_view = self.builder.get_object('sresults_treeview')
		##search results add (sadd) treeview and liststore
		self.sadd = self.builder.get_object('sadd_liststore')
		self.sadd_view = self.builder.get_object('sadd_treeview')
		#buttons
		self.sresults_clear = self.builder.get_object('sresults_clear')
		self.sresults_add_all = self.builder.get_object('sresults_add_all')
		self.sadd_clear = self.builder.get_object('sadd_clear')
		self.sadd_undo_last = self.builder.get_object('sadd_undo_last')
		self.sadd_commit = self.builder.get_object('sadd_commit')
		self.sadd_remove_unselected = self.builder.get_object('sadd_remove_unselected')
		#add columns to sresults tree view
		sresults_column_toggle = Gtk.TreeViewColumn("Toggle", renderer_toggle_sresults, active=0)
		sresults_column_definition = Gtk.TreeViewColumn("Definitions", renderer, text=1)
        self.sresults_view.append_column(sresults_column_toggle)
		self.sresults_view.append_column(sresults_column_definition)
		#add columns to sadd treeview
		sadd_column_toggle = Gtk.TreeViewColumn("Toggle", renderer_toggle_sadd, active=0)
		sadd_column_definition = Gtk.TreeViewColumn("Definitions", renderer, text=1)
        self.sadd_view.append_column(sadd_column_toggle)
		self.sadd_view.append_column(sadd_column_definition)
	
		#########################Add from Source Tab ##########################
		#Add from source (afs) text view
		self.afs_textview = self.builder.get_object('afs_textview')
		#search button
		self.add_to_list = self.builder.get_object('add_to_list')
		#afs liststore buttons
		self.afs_commit = self.builder.get_object('afs_commit')
		self.afs_clear = self.builder.get_object('afs_clear')
		self.afs_undo_last = self.builder.get_object('afs_undo_last')
		self.afs_remove_unselected = self.builder.get_object('afs_remove_unselected')
		#afs treeview liststore
		self.afs = self.builder.get_object('afs_liststore')
		self.afs_view = self.builder.get_object('afs_treeview')
		#afs treeview columns
		afs_column_toggle = Gtk.TreeViewColumn("Toggle", renderer_toggle_afs, active=0)
		afs_column_definition = Gtk.TreeViewColumn("Definitions", renderer, text=1)
        #add afs treeview columns
        self.afs_view.append_column(afs_column_toggle)
		self.afs_view.append_column(afs_column_definition)
		#create textbuffer for textview manipulation
		self.textbuffer = Gtk.TextBuffer()
		self.afs_textview.set_buffer(self.textbuffer)
		
		######################## Edit and Create Tab ########################
		#output (o) check and radio
		self.o_toggle_selected = self.builder.get_object('o_toggle_selected')
		self.o_toggle_all = self.builder.get_object('o_toggle_all')
		self.o_csv = self.builder.get_object('o_csv')
		self.o_tsv = self.builder.get_object('o_tsv')
		if self.settings.get_boolean("defaultoutputcsv"):
			self.o_csv.set_active(True)
		else:
			self.o_tsv.set_active(True)
		#buttons
		self.o_remove_unselected = self.builder.get_object('o_remove_unselected')
		self.o_generate = self.builder.get_object('o_generate')
		self.o_clear = self.builder.get_object('o_clear')
		self.o_commit_all = self.builder.get_object('o_commit_all')
		#o treeview liststore
		self.o = self.builder.get_object('o_liststore')
		self.o_view = self.builder.get_object('o_treeview')
		#o treeview columns
		o_column_toggle = Gtk.TreeViewColumn("Toggle", renderer_toggle_o, active=0)
		o_column_definition = Gtk.TreeViewColumn("Definitions", renderer, text=1)
        #add afs treeview columns
        self.o_view.append_column(o_column_toggle)
		self.o_view.append_column(o_column_definition)
		##list def copies for easy checking
		self.sresults_def_list = [] #this will always have an up to date list of defintions to match the items in the respective liststores
		self.sadd_def_list = []
		self.afs_def_list = []
		self.o_def_list = []
		######################## Menus ########################
		self.start_over = self.builder.get_object('start_over')
		
		
		
	#notes about program
	#lists (like []) are used to keep track of all liststores and treeview contents, for easiy comparison and membership checking. These lists are used when committing, syncing checked states, etc, and are modified whenever a treeview or liststore is modified and visa-versa. 	
		
	######################### Add From Search Tab #########################
	#Searching
	##method used to search edict and append the returned values to the #sresults treeview
	def search(self,widget):
		self.sresults.clear()
		key = widget.get_text()
		self.sresults_def_list = []  
		if key:
			for definition in e.search(key):
				self.sresults.append([False,definition])
				self.sresults_def_list.append(definition) #update the list with all definitions
			self.sync_checked_states(self.sadd,self.sadd_def_list,self.sresults,self.sresults_def_list)
	##do search on search field activate
	def on_search_field_activate(self,widget):
		self.search(widget)
	
	def search_string(self,key):
		return e.search(key)
	
	#sresults buttons
	def on_search_go_clicked(self,widget):
		self.search(self.search_field)
		
	def on_sresults_clear_clicked(self,widget):
		self.sresults.clear()
		self.sresults_def_list = []
		
	def on_sresults_add_all_clicked(self,widget):
		for item in self.sresults:
			if not item[1] in self.sadd_def_list:
				item[0] = 1 #check it
				self.sadd.append([True,item[1]])
				self.sadd_def_list.append(item[1])
	
	def on_sadd_remove_unselected_clicked(self,widget):
		self.remove_unselected(self.sadd)

	def on_sadd_commit_clicked(self,widget):
		if self.commit(self.sadd):
			self.sadd_def_list = []
		self.sync_checked_states(self.sadd,self.sadd_def_list,self.sresults,self.sresults_def_list)
	
	def on_sadd_clear_clicked(self,widget):
		if len(self.sadd):
			if self.confirm_on_remove:
				dialog = Continue(self)
		        response = dialog.run()
		        dialog.destroy()
		        if response == Gtk.ResponseType.YES:
					self.sadd.clear()
					self.sadd_def_list = []
					self.sync_checked_states(self.sadd,self.sadd_def_list,self.sresults,self.sresults_def_list)
				dialog.destroy()
			else:
				self.sadd.clear()
				self.sadd_def_list = []
				self.sync_checked_states(self.sadd,self.sadd_def_list,self.sresults,self.sresults_def_list)
	
	#cell toggle actions
	def on_cell_toggled_sadd(self, widget, path):
		self.sadd[path][0] = not self.sadd[path][0]
		if self.sadd[path][0]:#if it is checked
			if self.return_matching_iter(self.sadd[path][1],self.sresults,1): #if the same def is in sresults, check it
				self.sresults.set_value(self.return_matching_iter(self.sadd[path][1],self.sresults,1),0,1)
		elif self.sadd[path][1]:#if it is unchecked
			if self.return_matching_iter(self.sadd[path][1],self.sresults,1): #if the same def is in sresults, uncheck it
				self.sresults.set_value(self.return_matching_iter(self.sadd[path][1],self.sresults,1),0,0)
	
	def on_cell_toggled_sresults(self, widget, path):
        self.sresults[path][0] = not self.sresults[path][0]
		if self.sresults[path][0]: #if checked
			if self.sresults[path][1] not in self.sadd_def_list: #if its not in sadd list, add it. 
				self.sadd.append([self.sresults[path][0],self.sresults[path][1]])
				self.sadd_def_list.append(self.sresults[path][1])
			else: # it is in sadd list, so check it in sadd list
				self.sadd.set_value(self.return_matching_iter(self.sresults[path][1],self.sadd,1),0,1)
				
		elif self.sresults[path][1]: #if sresult is unchecked, remove it from sadd
			self.sadd.remove(self.return_matching_iter(self.sresults[path][1],self.sadd,1))
			if self.sresults[path][1] in self.sadd_def_list:
				self.sadd_def_list.remove(self.sresults[path][1])
	
	def sync_checked_states(self,liststore1,def_list1,liststore2,def_list2):
		'''if any of the items in the list stores are the same, the checked states will be synced. from ls1 to ls2'''
		#because whenever a list is modified, it is tracked in the x_def_list, these lists can be compared easily, and any matching definitions can be found, then grabbed with return_matching_iter, and sync states can be synced.
		path = -1
		if len(def_list1): #if there is anything in list
			for item in liststore1:
				path+=1
				if item[1] in def_list2:#self.sresults_def_list:
					liststore2.set_value(self.return_matching_iter(liststore1[path][1],self.sresults,1),0,item[0])
					#mark it same as sadd item
		else: 
			for item in liststore2:
				item[0] = 0
				
	######################### Add from Source Tab #########################	
	#buttons
	def on_add_to_list_clicked(self,widget):
			self.add_from_list()
	
	def add_from_list(self):
		text = self.textbuffer.get_text(self.textbuffer.get_start_iter(),self.textbuffer.get_end_iter(),False)
		failed_str = ''
		for key in text.split(): #for each key given by person
			if self.search_string(key):
				for definition in self.search_string(key): #for each definition it returns in a search
					if definition not in self.afs_def_list:#if it is not already in afs
						self.afs.append([True,definition])#append that def to afs listmodel
						self.afs_def_list.append(definition)
			else:
				failed_str = failed_str + key +'\n'
		self.textbuffer.set_text(failed_str)	
	
	def on_afs_clear_clicked(self,widget):
		if len(self.afs):
			if self.confirm_on_remove:
				dialog = Continue(self)
		        response = dialog.run()
		        if response == Gtk.ResponseType.YES:
					self.afs.clear()
					self.afs_def_list = []
				dialog.destroy()
			else:
				self.afs.clear()
				self.afs_def_list = []
			
	def on_afs_remove_unselected_clicked(self,widget):
		self.remove_unselected(self.afs)
	
	def on_afs_commit_clicked(self,widget):
		if self.commit(self.afs):
			self.afs_def_list = []
			
	def on_cell_toggled_afs(self, widget, path):
		self.afs[path][0] = not self.afs[path][0]	
		
	######################### Edit and Create Tab #########################	
	def on_o_clear_clicked(self,widget):
		if len(self.o):
			if self.confirm_on_remove:
				dialog = Continue(self)
		        response = dialog.run()
		        if response == Gtk.ResponseType.YES:
					self.o.clear()
					self.o_def_list = []
				dialog.destroy()
			else:
				self.o.clear()
				self.o_def_list = []
				
	def on_o_remove_unselected_clicked(self,widget):
		self.remove_unselected(self.o)

			
	def on_o_toggle_selected_clicked(self,widget):
		try:
			for item in self.o:
				item[0] = not item[0]
		except:
			pass
			
	def on_o_toggle_all_clicked(self,widget):
		try:
			val = not self.o[0][0]
			for item in self.o:
				item[0] = val
		except:
			pass
				
	def on_o_commit_all_clicked(self,widget):
		if self.commit(self.sadd):
			self.sadd_def_list = []
		if self.commit(self.afs):
			self.afs_def_list = []
			
	def on_o_generate_clicked(self,widget):
		if len(self.o):
			if self.o_tsv.get_active():
				output_format = 'tsv'
			elif self.o_csv.get_active():
				output_format = 'csv'
			if self.prompt_on_generate:
				self.GenerateOutputObj = GenerateOutput(self,self.output_dir,self.filename)
				response = self.GenerateOutputObj.run()
				self.output_dir = self.GenerateOutputObj.output_dir
				self.filename = self.GenerateOutputObj.filename
				self.create_output = self.GenerateOutputObj.create_output #see if create_output is true, if not, cancel was clicked
				self.GenerateOutputObj.destroy()
				if self.create_output:
					self.written_filename = e.write_output(self.o_def_list,self.output_dir,self.filename,output_format) #grab new filename, as it might be versioned
					self.done_notification()

			else:
				self.written_filename = e.write_output(self.o_def_list,self.output_dir,self.filename,output_format)
				self.done_notification()
		else:
			dialog = EmptyGenerate(self)
	        response = dialog.run()
			dialog.destroy()
			
	def on_cell_toggled_o(self, widget, path):
		try:
			self.o[path][0] = not self.o[path][0]
		except:
			pass
	
	######################### Menus #########################
	def on_start_over_activate(self,widget):
		self.o_def_list = []
		self.afs_def_list = []
		self.sresults_def_list = []
		self.sadd_def_list = []
		self.o.clear()
		self.afs.clear()
		self.sresults.clear()
		self.sadd.clear()
		self.textbuffer.set_text('')
		self.search_field.set_text('')
	######################### Applies to all tabs #########################
	
	def done_notification(self):
		message = 'Your file "' + self.written_filename +'" was generated at "' + self.output_dir +'"'
		done_notification = Notify.Notification.new(
		'Done Generating',
		message,
		None)
		done_notification.show ()
	
		
	def return_matching_iter(self,string,listStore,column):
		'''only returns itter for first instance, string is the string you want to find, list store and column denote where you want to find your string.'''
		path = -1
		for row in listStore:
			path+=1
			if row[column] == string:	
				return self.iter.get_iter_from_string(listStore,str(path))
			
	def remove_unselected(self,liststore):
		if liststore == self.sadd:
			def_list = self.sadd_def_list
		if liststore == self.afs:
			def_list = self.afs_def_list
		if liststore == self.o:
			def_list = self.o_def_list
		switch = 1
		while switch:
			iter_list = []
			def_dest_list = []
			path = -1
			for item in liststore:
				path += 1
				try:
					if item[0] == 0:
						iter_list.append(self.return_matching_iter(liststore[path][1],liststore,1))
						def_dest_list.append(item[1])
				except:
					pass	
			if not iter_list and not def_dest_list:
				switch = 0
			for item in iter_list:
				try:
					liststore.remove(item)
				except:
					pass
			for item in def_dest_list:
				try:
					def_list.remove(item)
				except:
					pass

	def check_for_duplicates(self,def_list1,def_list2):
		for item in def_list1:
			if item in def_list2:
				return True
		return False

	def commit(self,liststore): 
		if liststore == self.sadd:
			def_list = self.sadd_def_list
			tab = '\"Add From Search\"'
		if liststore == self.afs:
			def_list = self.afs_def_list
			tab = '\"Add From Vocab List\"'
			def_list = self.sadd_def_list
		if liststore == self.afs:
			def_list = self.afs_def_list
		if self.check_for_duplicates(def_list,self.o_def_list):#if duplicates
			if self.commit_dialog: #if dialog, do dialog
				dialog = DuplicatesCommit(self,tab)
		        response = dialog.run()
		        if response == Gtk.ResponseType.YES:
					for item in liststore:
						self.o.append([item[0],item[1]])
						self.o_def_list.append(item[1])
					liststore.clear()
					dialog.destroy()
					return True
		        if response == Gtk.ResponseType.NO: 
		            for item in liststore:
						if item[1] not in self.o_def_list:
							self.o.append([item[0],item[1]])
							self.o_def_list.append(item[1])
					liststore.clear()
					dialog.destroy()
					return True
				if response == Gtk.ResponseType.CANCEL:
					dialog.destroy()
					return False
			elif self.commit_duplicates: #else, if they want to commit all, do that
				for item in liststore:
					self.o.append([item[0],item[1]])
					self.o_def_list.append(item[1])
				liststore.clear()
				return True
			elif not self.commit_duplicates: #else, if they dont want to commit duplicates, but still want to commit..
				for item in liststore:
					if item[1] not in self.o_def_list:
						self.o.append([item[0],item[1]])
						self.o_def_list.append(item[1])
				liststore.clear()
				return True
		elif not self.check_for_duplicates(def_list,self.o_def_list):
			for item in liststore:
				if item[1] not in self.o_def_list:
					self.o.append([item[0],item[1]])
					self.o_def_list.append(item[1])
			liststore.clear()
			return True
		return False

