#blend in to the surroundings

from gi.repository import Gtk


class ColourStruct(object):
    def __init__(self):
        self.red = 0.0
        self.green = 0.0
        self.blue = 0.0
        self.alpha = 0.0

class Colour(object):
    @classmethod
    def from_widget(cls, widget):
        ctx = widget.get_style_context()
        return cls(ctx.get_background_color(Gtk.StateFlags.NORMAL))

    def __init__(self, colour):
        self.colour = colour
        
    def get_red(self):
        return self.colour.red
        
    def set_red(self, v):
        self.colour.red = v
        
    def get_blue(self):
        return self.colour.blue
        
    def set_blue(self, v):
        self.colour.blue = v
        
    def get_green(self):
        return self.colour.green
        
    def set_green(self, v):
        self.colour.green = v
        
    def get_alpha(self):
        return self.colour.alpha
        
    def set_alpha(self, v):
        self.colour.alpha = v
        
    def get_rgb(self):
        return (self.colour.red, self.colour.green, self.colour.blue)
    
    def set_rgb(self, v):
        self.colour.red = v[0]
        self.colour.green = v[1]
        self.colour.blue = v[2]
        
    def get_rgba(self):
        return (self.colour.red, self.colour.green, self.colour.blue, self.colour.alpha)
        
    def set_rgba(self, v):
        self.colour.red = v[0]
        self.colour.green = v[1]
        self.colour.blue = v[2]
        self.colour.alpha = v[3]
        
    def to_hex(self, v):
        return hex(int(v*255.999)).split('x')[1]
        
    def get_html_rgb(self):
        return '#'+''.join(map(self.to_hex, self.get_rgb()))
        
    def get_html_rgba(self):
        return '#'+''.join(map(self.to_hex, self.get_rgba()))
        
    def get_inverse(self, alpha=False):
        s = ColourStruct()
        s.red = 1.0 - self.colour.red
        s.blue = 1.0 - self.colour.blue
        s.green = 1.0 - self.colour.green
        if alpha:
            s.alpha = 1.0 - self.colour.alpha
        return Colour(s)
        
    def replace_rgb(self, text, replace):
        return text.replace(replace, self.get_html_rgb())
        
    def replace_rgba(self, text, replace):
        return text.replace(replace, self.get_html_rgba())
        
    def camo_rgb(self, inf, of, replace):
        of.write(self.replace_rgb(inf.read(), replace))
        
    def camo_rgba(self, inf, of, replace):
        of.write(self.replace_rgba(inf.read(), replace))
        
class Gradient(object):
    def __init__(self, a, b):
        self.a = a
        self.delta_red = b.get_red() - a.get_red()
        self.delta_green = b.get_green() - a.get_green()
        self.delta_blue = b.get_blue() - a.get_blue()
        self.delta_alpha = b.get_alpha() - a.get_alpha()
        
    def get(self, proportion):
        c = ColourStruct()
        c.red = self.a.get_red() + self.delta_red * proportion
        c.green = self.a.get_green() + self.delta_green * proportion
        c.blue = self.a.get_blue() + self.delta_blue * proportion
        c.alpha = self.a.get_alpha() + self.delta_alpha * proportion
        return Colour(c)

if __name__ == '__main__':
    w = Gtk.Window()
    ctx = w.get_style_context()
    ctx.add_class(Gtk.STYLE_CLASS_PRIMARY_TOOLBAR)
    c = Colour.from_widget(w)
    inf = open('../data/media/download-monitor.svg')
    of = open('/tmp/1.svg', 'w')
    c.camo_rgba(inf, of, '#dd4814')
    
    
    
