# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 <Duncan Davis> <duncanjdavis@gmail.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

# This is your preferences dialog.
#
# Define your preferences in
# data/glib-2.0/schemas/net.launchpad.download-monitor.gschema.xml
# See http://developer.gnome.org/gio/stable/GSettings.html for more info.

from gi.repository import Gio # pylint: disable=E0611

import gettext
from gettext import gettext as _
gettext.textdomain('download-monitor')

import logging
logger = logging.getLogger('download_monitor')

from download_monitor_lib.PreferencesDialog import PreferencesDialog

class PreferencesDownloadMonitorDialog(PreferencesDialog):
    __gtype_name__ = "PreferencesDownloadMonitorDialog"

    def finish_initializing(self, builder): # pylint: disable=E1002
        """Set up the preferences dialog"""
        super(PreferencesDownloadMonitorDialog, self).finish_initializing(builder)

        # Bind each preference widget to gsettings
        settings = Gio.Settings("net.launchpad.download-monitor")
        #widget = self.builder.get_object('example_entry')
        #settings.bind("example", widget, "text", )
        self.downquotagib = self.builder.get_object('spinbutton1')
        self.downquotamib = self.builder.get_object('spinbutton2')
        self.upquotagib = self.builder.get_object('spinbutton3')
        self.upquotamib = self.builder.get_object('spinbutton4')
        self.totalquotagib = self.builder.get_object('spinbutton5')
        self.totalquotamib = self.builder.get_object('spinbutton6')
        settings.bind("downquotagib", self.downquotagib, "value", Gio.SettingsBindFlags.DEFAULT)
        settings.bind("downquotamib", self.downquotamib, "value", Gio.SettingsBindFlags.DEFAULT)
        settings.bind("upquotagib", self.upquotagib, "value", Gio.SettingsBindFlags.DEFAULT)
        settings.bind("upquotamib", self.upquotamib, "value", Gio.SettingsBindFlags.DEFAULT)
        settings.bind("totalquotagib", self.totalquotagib, "value", Gio.SettingsBindFlags.DEFAULT)
        settings.bind("totalquotamib", self.totalquotamib, "value", Gio.SettingsBindFlags.DEFAULT)


