def make_svg(data, offsetx=0, offsety=0, margin=100, maxbarwidth=500, barheight=20, linewidth=5, text_correction=12, background="#FFFFFF"):
    try:
        maxval = 0.0
        ooy = offsety
        svgbody = "<g>%s</g>\n<g>%s</g>\n<g>%s</g>\n"
        bars = ''
        text = ''
        lines = ''
        for b in data['bars']:
            for v in b[1][1]:
                if v > maxval:
                    maxval = v
        for l in data['lines']:
            if l[0] > maxval:
                maxval = l[0]
        if maxval == 0.0:
            print("WARNING: There may not be enough data to generate a chart.")
            maxval = 1.0
                
        for bar in data['bars']:
            offsety += barheight
            text += '<text x="%i" y="%i" font-family="Ubuntu,sans-serif">%s</text>\n' % (offsetx, offsety+text_correction, bar[0])
            l = len(bar[1][0])
            i = 0
            while i < l:
                offsety += barheight
                bars += '<rect x="%i" y="%i" width="%.2f" height="%i" fill="%s" />\n' % (offsetx + margin, offsety, (maxbarwidth*bar[1][1][i])/maxval, barheight, bar[1][2][i])
                text += '<text x="%i" y="%i" font-family="Ubuntu,sans-serif">%s</text>\n' % (offsetx + margin + 2*linewidth, offsety+text_correction, bar[1][0][i])
                i += 1
                
        maxx = offsetx + margin + linewidth + maxbarwidth
        maxy = offsety + barheight * 2
                
        for line in data['lines']:
            lines += '<rect x="%.2f" y="%i" width="%i" height="%i" fill="%s" />\n' % (
                offsetx + margin + (line[0]*maxbarwidth)/maxval,
                ooy, linewidth, maxy, line[1])
                
        svgbody = svgbody % (bars, lines, text)
        
        width = maxx + 2*linewidth
        return '\n'.join((
            '<?xml version="1.0" encoding="UTF-8" ?><svg width="%i" height="%i" version="1.1"><rect x="0" y="0" width="%i" height="%i" fill="%s" />'%(
                width, maxy, width, maxy, background),
            svgbody, '</svg>'
        ))
    except Exception, e:
        print('ERROR: Failed to create chart! ' + repr(e))
        return '<?xml version="1.0" encoding="UTF-8" ?><svg width="%i" height="%i" version="1.1"><rect x="0" y="0" width="%i" height="%i" fill="%s" /></svg>'

