# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Pete Burgers <deltify81@gmail.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import threading
import thread
import logging
logger = logging.getLogger(__name__)

from gi.repository import GObject
GObject.threads_init()

class Task(object):

   def __init__(self, generator, loop_callback=None, complete_callback=None):
       self.generator = generator
       self.loop_callback = loop_callback
       self.complete_callback = complete_callback
       self.is_alive = False
       self.is_stopping = False

   def _start(self, *args, **kwargs):
       self.is_alive = True
       try:
          for ret in self.generator(*args, **kwargs):
             if self.is_stopping:
                self.is_alive = False
                self.is_stopping = False
                logger.debug("Exiting thread")
                thread.exit()
             GObject.idle_add(self._loop, ret)
       finally:
          if self.complete_callback:
             GObject.idle_add(self.complete_callback)
          self.is_alive = False

   def _loop(self, ret):
       if ret is None:
           ret = ()
       if not isinstance(ret, tuple):
           ret = (ret,)
       if self.loop_callback:
          self.loop_callback(*ret)

   def start(self, *args, **kwargs):
       threading.Thread(target=self._start, args=args, kwargs=kwargs).start()

   def stop(self):
       if self.is_alive:
          logger.info("Waiting for final operation to complete...")
          self.is_stopping = True

