import sqlite3
import json
import os
import os.path
from gi.repository import GObject


class CuttleRecords(GObject.GObject):
	__gsignals__ = {
			'save': (GObject.SIGNAL_RUN_FIRST, None, (GObject.TYPE_PYOBJECT,)),
			'delete': (GObject.SIGNAL_RUN_FIRST, None, (int,))
		}


	def __init__(self, record_type, record_class):
		GObject.GObject.__init__(self)
		self._record_type = record_type
		self._record_class = record_class
		cdir = os.path.abspath(os.path.expanduser('~/.cuttlefish'))
		if not os.path.isdir(cdir):
			os.mkdir(cdir)
		self._dbfile = os.path.join(cdir, 'reflexes.db')
		if not os.path.isfile(self._dbfile):
			c = sqlite3.connect(self._dbfile)
			c.execute('CREATE TABLE %s (record_id INTEGER PRIMARY KEY AUTOINCREMENT, data TEXT);' % self._record_type)
			c.close()
		

		
	def create(self):
		record = self._record_class(self._record_class.getDefaults())
		return record
	
	def __mergeDefaults(self, extra):
		defaults = self._record_class.getDefaults()
		defaults.update(extra)
		return defaults
	
	def list(self):
		records = []

		c = sqlite3.connect(self._dbfile)
		for row in c.execute('SELECT record_id, data FROM %s' % self._record_type):
			data = json.loads(row[1])
			record = self._record_class(self.__mergeDefaults(data))
			record.record_id = row[0]
			records.append(record)
		c.close()
		return records
	

	def get(self, record_id):
		c = sqlite3.connect(self._dbfile)
		row = c.execute('SELECT record_id, data FROM %s WHERE record_id = ?' % self._record_type, (record_id,)).fetchone()
		c.close()
		data = json.loads(row[1])
		record = self._record_class(self.__mergeDefaults(data))
		record.record_id = row[0]
		return record
	
	def save(self, record):
		c = sqlite3.connect(self._dbfile)
		data = json.dumps(record.get_data())
		if record.record_id:
			c.execute('UPDATE %s SET data = ? WHERE record_id = ?' % self._record_type, (data, record.record_id,))
		else:
			data = json.dumps(record.get_data())
			record_id = c.execute('INSERT INTO %s VALUES (NULL, ?)' % self._record_type, (data,)).lastrowid
			record.record_id = record_id
		c.commit()
		c.close()
		self.emit('save', record)
		
	def delete(self, record_id):
		c = sqlite3.connect(self._dbfile)
		c.execute('DELETE FROM %s WHERE record_id = ?' % self._record_type, (record_id,))
		c.commit()
		c.close()
		self.emit('delete', record_id)
	

class CuttleRecord:
	def __init__(self, data={}):
		self._data = data
		self.record_id = None

	def __getitem__(self, key):
		return self._data[key]

	def __setitem__(self, key, value):
		self._data[key] = value

	def __delitem__(self, key):
		del self._data[key]

	def get_data(self):
		return self._data


class Reflex(CuttleRecord):
	def __init__(self, data={}):
		CuttleRecord.__init__(self, data)
		
	@classmethod
	def getDefaults(clazz):
		return {
			'name': 'New Reflex',
			'showNotification' : True,
			'listInIndicator' : True,
			'event': {
				'isActive' : False,
				'type' : '',
				'params' : {}
			},
			'actions' : [],
		}
		
	

class Reflexes(CuttleRecords):
	
	def __init__(self):
		CuttleRecords.__init__(self, 'reflexes', Reflex)
		

REFLEXES = Reflexes()