from cuttlefish.actions import CuttleAction
from cuttlefish.plugins import CuttlePlugin
from cuttlefish.events import DBusEvent
from cuttlefish.params import SelectParam

import dbus

class Suspend(CuttleAction, CuttlePlugin):
	NAME = 'Suspend'
	DESCP = 'Suspend the computer'
	CATEGORY = 'Power Management'

	def __init__(self):
		CuttleAction.__init__(self)
		CuttlePlugin.__init__(self)

	def execute(self):
		bus = dbus.SystemBus()
		obj = bus.get_object('org.freedesktop.UPower', '/org/freedesktop/UPower')
		upower = dbus.Interface(obj, 'org.freedesktop.UPower')
		
		upower.Suspend()


class Hibernate(CuttleAction, CuttlePlugin):
	NAME = 'Hibernate'
	DESCP = 'Hibernate the computer'
	CATEGORY = 'Power Management'

	def __init__(self):
		CuttleAction.__init__(self)
		CuttlePlugin.__init__(self)
		
	def execute(self):
		bus = dbus.SystemBus()
		obj = bus.get_object('org.freedesktop.UPower', '/org/freedesktop/UPower')
		upower = dbus.Interface(obj, 'org.freedesktop.UPower')
		
		upower.Hibernate()


class Shutdown(CuttleAction, CuttlePlugin):
	NAME = 'Shutdown'
	DESCP = 'Shut down the computer'
	CATEGORY = 'Power Management'

	def __init__(self):
		CuttleAction.__init__(self)
		CuttlePlugin.__init__(self)

	def execute(self):
		bus = dbus.SystemBus()
		obj = bus.get_object('org.freedesktop.ConsoleKit', '/org/freedesktop/ConsoleKit/Manager')
		consoleKit = dbus.Interface(obj, 'org.freedesktop.ConsoleKit.Manager')
		
		consoleKit.Stop()


class Reboot(CuttleAction, CuttlePlugin):
	NAME = 'Reboot'
	DESCP = 'Reboot the computer'
	CATEGORY = 'Power Management'

	def execute(self):
		bus = dbus.SystemBus()
		obj = bus.get_object('org.freedesktop.ConsoleKit', '/org/freedesktop/ConsoleKit/Manager')
		consoleKit = dbus.Interface(obj, 'org.freedesktop.ConsoleKit.Manager')
		
		consoleKit.Restart()


class WakeupMonitor(DBusEvent, CuttlePlugin):
	NAME = 'Wake Up'
	DESCP = 'React when the computer wakes up from suspend or hibernate'
	PARAMS = {'type' : 2}
	CATEGORY = 'Power Management'


	class Editor(CuttlePlugin.Editor):
		def begin(self):
			return {'type' : SelectParam('Kind of wakeup', {
				0 : 'Wake from suspend only',
				1 : 'Wake from hibernate only',
				2 : 'Wake from suspend or hibernate'
				})}


	def __init__(self):
		DBusEvent.__init__(self, self.on_wakeup, 'NotifyResume', 'org.freedesktop.UPower', '/org/freedesktop/UPower', DBusEvent.USE_SYSTEM_BUS)
		CuttlePlugin.__init__(self)
		
	def on_wakeup(self, wakeUpType):
		types = [
			'suspend',
			'hibernate',
			wakeUpType
		]

		if wakeUpType == types[self._params['type']]:
			self.trigger()