from cuttlefish.actions import CuttleAction
from cuttlefish.plugins import CuttlePlugin
from cuttlefish.events import CuttleEvent
from cuttlefish.params import SelectParam

from cuttlefish.reflexes import REFLEXES
from cuttlefish.engine import ENGINE

class ChangeReflex(CuttleAction):
	CATEGORY = "Cuttlefish Internals"
	PARAMS = {
		'reflex' : ''
	}
	
	class Editor(CuttlePlugin.Editor):
		def begin(self):
			rdict = {}
			for r in REFLEXES.list():
				rdict[r.record_id] = r['name']

			return {
				'reflex': SelectParam('Reflex', rdict, str)
			}


	def __init__(self, activate):
		CuttleAction.__init__(self)
		self._activate = activate

	def execute(self):
		r = REFLEXES.get(self._params['reflex'])
		r['event']['isActive'] = self._activate
		REFLEXES.save(r)



class ActivateReflex(ChangeReflex, CuttlePlugin):
	NAME = "Activate reflex"
	DESCP = "Activate another reflex"

	def __init__(self):
		ChangeReflex.__init__(self, True)
		CuttlePlugin.__init__(self)


class DeactivateReflex(ChangeReflex, CuttlePlugin):
	NAME = "Deactivate reflex"
	DESCP = "Deactivate another reflex"

	def __init__(self):
		ChangeReflex.__init__(self, False)
		CuttlePlugin.__init__(self)



class CuttleEngineMonitor(CuttleEvent):
	CATEGORY = "Cuttlefish Internals"

	def __init__(self, event):
		CuttleEvent.__init__(self)
		self._event = event

	def setup(self):
		self._hid = ENGINE.connect(self._event, self.on_engine_event)

	def teardown(self):
		ENGINE.disconnect(self._hid)

	def on_engine_event(self, engine):
		pass


class CuttleEngineStartup(CuttleEngineMonitor, CuttlePlugin):
	NAME = "Cuttlefish Startup"
	DESCP = "React when cuttlefish is started"


	def __init__(self):
		CuttleEngineMonitor.__init__(self, 'startup')
		CuttlePlugin.__init__(self)

	def on_engine_event(self, engine):
		self.trigger()
	

class CuttleEngineShutdown(CuttleEngineMonitor, CuttlePlugin):
	NAME = "Cuttlefish Shutdown"
	DESCP = "React when cuttlefish is stopped"


	def __init__(self):
		CuttleEngineMonitor.__init__(self, 'shutdown')
		CuttlePlugin.__init__(self)

	def on_engine_event(self, engine):
		self.trigger()
