import os
import os.path
import sys
import imp
import inspect
import datetime
from traceback import format_exception
import logging

_mod_logger = logging.getLogger('cuttlefish.plugins')
_engine_logger = logging.getLogger('cuttlefish.engine.Engine')


class CuttlePlugin:
	NAME = "UNKOWN"
	DESCP = "No documnentation passed with this plugin."
	CATEGORY = "Unkown"
	PARAMS = {}

	def __init__(self):
		self._params = {}
		self.set_params(self.PARAMS)
		
	def get_params(self):
		return self._params
	
	def set_params(self, params):
		self._params.update(params)
		

	class Editor:
		def set_params(self, params):
			self._params = params

		def get_params(self):
			return self._params


		def begin(self):
			return {}

		def finish(self, ui):
			pass


class Manager:
	def __init__(self):
		self._dirs = []
		self._plugins = {}

		self.__add_dir('cuttlefish.plugins.user', '~/.cuttlefish/plugins')
		self.__add_dir('cuttlefish.plugins.default', '/opt/extras.ubuntu.com/cuttlefish/cuttlefish/plugins')
		self.__add_dir('cuttlefish.plugins.altdefault', '/usr/lib/python2.7/dist-packages/cuttlefish/plugins')

	def __add_dir(self, modid, dir):
		dir = os.path.abspath(os.path.expandvars(os.path.expanduser(dir)))
		if os.path.isdir(dir):
			self._dirs.append((modid, dir))


	def is_plugin(self, path):
		fname = os.path.basename(path)
		if fname.endswith('.py'):
			for modid, dir in self._dirs:
				if path.startswith(dir):
					return True
		return False
 
	def reload(self):
		self._plugins = {}

		for modid, dir in self._dirs:
			for mod_file in [f for f in os.listdir(dir) if (not f.startswith('__')) and f.endswith('.py')]:
				module = mod_file[:-3]
				f = None
				try:
					f, path, desc = imp.find_module(module, [dir])
					mod = imp.load_module(modid + '_' + module, f, path, desc)
					for cname, clazz in inspect.getmembers(mod, inspect.isclass):
						if not clazz is CuttlePlugin and CuttlePlugin in inspect.getmro(clazz) and cname not in self._plugins:
							self._plugins[cname] = clazz
							_mod_logger.info("Loaded plugin '%s' from '%s'" % (cname, os.path.join(dir, mod_file)))
				finally:
					if f:
						f.close()

	def list(self, parent):
		for cname, clazz in self._plugins.items():
			if parent in inspect.getmro(clazz):
				yield (cname, clazz)


	def get_class(self, parent, id, fallback):
		result = fallback
		if id in self._plugins and parent in inspect.getmro(self._plugins[id]):
			result = self._plugins[id]
		else:
			id = 'UNKOWN'
		result.logger = logging.getLogger('cuttlefish.plugins.%s' % id)
		return result


MANAGER = Manager()



def debug(msg):
	_mod_logger.warning('THE DEBUG FUNCTION IS DEPRECATED. Please use self.logger.debug()')
	_mod_logger.debug(msg)

def format_plugin_exc(exc_info = None):
	if not exc_info:
		exc_info = sys.exc_info()
	return "%s\n%s\n" % (exc_info[1], "".join(format_exception(*exc_info)))

_parentExcepthook = sys.excepthook
def _handle_exc(type, value, traceback):
	# Some exceptions in plugins are not catched this way... so I allow
	# all exceptions to be logged
	#tb = traceback
	#while tb.tb_next:
	#	tb = tb.tb_next
	#if MANAGER.is_plugin(inspect.getframeinfo(tb).filename):
	_engine_logger.error(format_plugin_exc((type, value, traceback)))
	_parentExcepthook(type, value, traceback)

sys.excepthook = _handle_exc

EXAMPLE_CODE = """from cuttlefish.actions import CuttleAction
from cuttlefish.events import CuttleEvent
from cuttlefish.plugins import CuttlePlugin
from cuttlefish.params import StringParam, FileParam

from gi.repository import GObject
import os.path


class HelloWorldWatcher(CuttleEvent, CuttlePlugin):
	NAME = "Hello World Watcher"
	DESCP = "Checks for ~/HelloWorld.txt"
	CATEGORY = "Your Plugins"

	def __init__(self):
		CuttleEvent.__init__(self)
		CuttlePlugin.__init__(self)


	def _isCreated(self):
		return os.path.isfile(os.path.join(os.path.expanduser('~'), 'HelloWorld.txt'))

	def setup(self):
		self._created = self._isCreated()
		self._hid = GObject.timeout_add(1000, self._check)


	def teardown(self):
		GObject.source_remove(self._hid)

	def _check(self):
		created = self._isCreated()
		if not self._created and created:
			self.logger.debug('Just testing the debug functionality (this is written to /tmp/cuttlefish.log)')
			self.trigger()
		self._created = created

		return True


class HelloWorldWriter(CuttleAction, CuttlePlugin):
	NAME = "Hello World Writer"
	DESCP = "Writes something to ~/HelloWorld.txt"
	CATEGORY = "Your Plugins"
	PARAMS = {
		'msg' : 'Hello World :-)',
		'file' : os.path.join(os.path.expanduser('~'), 'HelloWorld.txt')
	}

	class Editor(CuttlePlugin.Editor):
		ORDER = ['msg', 'file']

		def begin(self):
			return {
				'msg' : StringParam('Your message'),
				'file': FileParam('The File')
			}



	def __init__(self):
		CuttleAction.__init__(self)
		CuttlePlugin.__init__(self)


	def execute(self):
		with open(self._params['file'], 'w') as hwf:
			hwf.write(self._params['msg'])

"""
