from gi.repository import GObject, Gtk
from cuttlefish.plugins import CuttlePlugin, MANAGER
import dbus


class CuttleEvent(GObject.GObject):
	NAME = "None"
	
	__gsignals__ = {
			'triggered': (GObject.SIGNAL_RUN_FIRST, None, ())
		}

	def __init__(self):
		GObject.GObject.__init__(self)
		
	def setup(self):
		pass
		
	def teardown(self):
		pass
			
	def trigger(self):
		self.emit('triggered')

	

class DBusEvent(CuttleEvent):
	USE_SYSTEM_BUS = 0
	USE_SESSION_BUS = 1

	def __init__(self, callback, signal_name, dbus_interface, path, whichBus=USE_SESSION_BUS):
		CuttleEvent.__init__(self)
		self._callback = callback
		self._signal_name = signal_name
		self._dbus_interface = dbus_interface
		self._path = path
		if whichBus == DBusEvent.USE_SESSION_BUS:
			self._bus = dbus.SessionBus()
		else:
			self._bus = dbus.SystemBus()

	def setup(self):		
		__str = lambda x : hasattr(x, '__call__') and x() or x

		self._hid = self._bus.add_signal_receiver(self._callback, 
				signal_name=__str(self._signal_name), 
				dbus_interface=__str(self._dbus_interface), 
				path=__str(self._path))	
		
	def teardown(self):
		self._bus.remove_signal_receiver(self._hid)


class FallbackEvent(CuttleEvent, CuttlePlugin):
	def __init__(self):
		CuttleEvent.__init__(self)
		CuttlePlugin.__init__(self)


class EventManager:
				
	def get_liststore(self):
		store = Gtk.ListStore(str, str, str, str)
		for cname, event in MANAGER.list(CuttleEvent):
			store.append([cname, event.NAME, event.DESCP, event.CATEGORY])
		store.set_sort_column_id(1, Gtk.SortType.ASCENDING)
		return store

	def get_categories(self):
		store = Gtk.ListStore(str)
		store.append(['All Categories'])
		for cat in set([event.CATEGORY for key, event in MANAGER.list(CuttleEvent)]):
			store.append([cat])
		store.set_sort_column_id(0, Gtk.SortType.ASCENDING)
		return store



	def get_instance(self, record):
		clazz = self.get_class(record['event']['type'])
		instance = clazz()
		if record['event']['params']:
			instance.set_params(record['event']['params'])
		return instance

	def get_class(self, id):
		return MANAGER.get_class(CuttleEvent, id, FallbackEvent)