# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Alexander von Bremen-Kuehne <noneed4anick@gmail.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import optparse

import gettext
from gettext import gettext as _
gettext.textdomain('cuttlefish')

from gi.repository import Gtk, Gdk, GLib, Gio # pylint: disable=E0611

import logging
from logging.handlers import RotatingFileHandler
logger = logging.getLogger('cuttlefish')
logger.setLevel(logging.DEBUG)
fh = RotatingFileHandler('/tmp/cuttlefish.log', maxBytes=100000, backupCount=5)
fh.setLevel(logging.DEBUG)
fh.setFormatter(logging.Formatter('[%(asctime)s] %(levelname)s in %(name)s: %(message)s'))


settings = Gio.Settings("net.launchpad.cuttlefish")

def on_logging_changed(_settings, key):
    if settings.get_boolean("logging"):
        logger.addHandler(fh)
    else:
        logger.removeHandler(fh)

settings.connect("changed::logging", on_logging_changed)
on_logging_changed(None, None)

import dbus
from dbus.mainloop.glib import DBusGMainLoop
DBusGMainLoop(set_as_default=True)

from cuttlefish import CuttlefishWindow
from cuttlefish.plugins import MANAGER
MANAGER.reload()

from cuttlefish.engine import ENGINE
from cuttlefish_lib import set_up_logging, get_version

GLib.threads_init()
Gdk.threads_init()
    
def parse_options():
    """Support for command line options"""
    parser = optparse.OptionParser(version="%%prog %s" % get_version())
    parser.add_option(
        "-v", "--verbose", action="count", dest="verbose",
        help=_("Show debug messages (-vv debugs cuttlefish_lib also)"))
    parser.add_option("-H", "--hidden",
                  action="store_true", dest="hidden", default=False,
                  help="Start without showing main window")

    (options, args) = parser.parse_args()

    set_up_logging(options)
    return options


def main():
    'constructor for your class instances'
    opts = parse_options()

    # Run the application.    
    ENGINE.setup()
    window = CuttlefishWindow.CuttlefishWindow()
    if not opts.hidden:
        window.show()
    Gtk.main()
    ENGINE.teardown()
