# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Alexander von Bremen-Kuehne <noneed4anick@gmail.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from gi.repository import Gtk # pylint: disable=E0611

from cuttlefish_lib.helpers import get_builder

import gettext
from gettext import gettext as _
gettext.textdomain('cuttlefish')

class SelectDialog(Gtk.Dialog):
    __gtype_name__ = "SelectDialog"

    def __new__(cls):
        """Special static method that's automatically called by Python when 
        constructing a new instance of this class.
        
        Returns a fully instantiated SeleectDialog object.
        """
        builder = get_builder('SelectDialog')
        new_object = builder.get_object('select_dialog')
        new_object.finish_initializing(builder)
        return new_object

    def finish_initializing(self, builder):
        """Called when we're finished initializing.

        finish_initalizing should be called after parsing the ui definition
        and creating a SelectDialog object with it in order to
        finish initializing the start of the new SelectDialog
        instance.
        """
        # Get a reference to the builder and set up the signals.
        self.builder = builder
        self.ui = builder.get_ui(self)

        self.ui.tvGeneric.append_column(Gtk.TreeViewColumn("Type", Gtk.CellRendererText(), text=1))
        self.ui.tvCategory.append_column(Gtk.TreeViewColumn("Category", Gtk.CellRendererText(), text=0))


    def set_title(self, title):
        self.ui.lblTitle.set_text(title)
        Gtk.Dialog.set_title(self, title)

    def set_models(self, model, cats):
        self._catFilter = None
        self._txtFilter = ''
        self.ui.tvCategory.set_model(cats)
        modelfilter = model.filter_new()
        modelfilter.set_visible_func(self._filter)
        self.ui.tvGeneric.set_model(modelfilter)
        self.ui.tvGeneric.set_cursor(0)
        self.ui.tvCategory.set_cursor(0)

    def _filter(self, model, iter, data=None):
        isValid = True
        if self._catFilter:
            isValid = self._catFilter == model[iter][3]

        if isValid and self._txtFilter:
            isValid = self._txtFilter.upper() in model[iter][1].upper()

        return isValid
       
    def _check_ok_btn(self):
        path, col = self.ui.tvGeneric.get_cursor()
        self.ui.btn_ok.set_sensitive(path != None)

    def on_tvCategory_cursor_changed(self, widget, data=None):
        path, col = self.ui.tvCategory.get_cursor()
        if path:
            model = self.ui.tvCategory.get_model()
            i = model.get_iter(path)
            if model[i][0] == 'All Categories':
                self._catFilter = None
            else:    
                self._catFilter = model[i][0]
            self.ui.tvGeneric.get_model().refilter()
            self._check_ok_btn()

    def on_txtFilter_icon_release(self, widget, icon_pos, event, data=None):
        self.ui.txtFilter.set_text('')

    def on_txtFilter_changed(self, widget, data=None):
        self._txtFilter = self.ui.txtFilter.get_text()
        self.ui.tvGeneric.get_model().refilter()
        self._check_ok_btn()


    def on_tvGeneric_cursor_changed(self, widget, data=None):
        self._check_ok_btn()
        path, col = self.ui.tvGeneric.get_cursor()
        if path:
            model = self.ui.tvGeneric.get_model()
            i = model.get_iter(path)
            self.ui.lblDescp.set_text(model[i][2])


    def on_btn_ok_clicked(self, widget, data=None):
        path, col = self.ui.tvGeneric.get_cursor()
        if path:
            model = self.ui.tvGeneric.get_model()
            i = model.get_iter(path)

            fullmodel = model.get_model()
            fi = model.convert_iter_to_child_iter(i)
            idx = fullmodel.get_path(fi).get_indices()[0]
            
            self.response(idx)

    def on_btn_cancel_clicked(self, widget, data=None):
        self.response(-1)


if __name__ == "__main__":
    dialog = ActiontypedialogDialog()
    dialog.show()
    Gtk.main()
