#!/usr/bin/python
# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 John Vrbanac <john.vrbanac (at) linux.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from cuckoo.CuckooAlarmList import CuckooAlarmList
from cuckoo.CuckooAlarmData import CuckooAlarmData

import sys
import time
import os.path
import unittest
sys.path.insert(0, os.path.realpath(os.path.join(os.path.dirname(__file__), "..")))

class TestCuckooAlarmList(unittest.TestCase):
	_instance = None
	
    def setUp(self):
		self._instance = CuckooAlarmList()
	
	def test_section_to_data(self):
		tmpData = CuckooAlarmData()
		tmpData.set_hour(11)
		tmpData.set_minute(24)
		tmpData.set_ampm("AM")
		tmpData.set_audio_filename("test.ogg")
		tmpData.set_volume(1.5)
		tmpData.set_activated(True)
		
		name = self._instance.generate_alarm_section(tmpData)
		
		parsedData = self._instance.read_alarm_section(name)
		
		self.assertEquals(11, parsedData.get_hour())
		self.assertEquals(24, parsedData.get_minute())
		self.assertEquals("AM", parsedData.get_ampm())
		self.assertEquals("test.ogg", parsedData.get_audio_filename())
		self.assertEquals(1.5, parsedData.get_volume())
		self.assertEquals(True, parsedData.get_activated())		

if __name__ == '__main__':    
    unittest.main()
