#!/usr/bin/python
# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 John Vrbanac <john.vrbanac (at) linux.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from cuckoo.CuckooAlarmData import CuckooAlarmData

import sys
import time
import os.path
import unittest
sys.path.insert(0, os.path.realpath(os.path.join(os.path.dirname(__file__), "..")))

class TestCuckooAlarmData(unittest.TestCase):
	_instance = None

    def setUp(self):
        self._instance = CuckooAlarmData()

	def test_set_from_time_str(self):
		self._instance.set_from_time_str("2:25 PM")
		self.assertEquals(2, self._instance.get_hour())
		self.assertEquals(25, self._instance.get_minute())
		self.assertEquals("PM", self._instance.get_ampm())
	
	def test_single_digit_minute(self):
		self._instance.set_hour(1)
		self._instance._minute = 0
		self._instance.set_ampm("AM")

		self.assertEqual("1:0 AM", self._instance.get_time())
	
	def test_convert_to_time(self):
		self._instance.set_hour(1)
		self._instance.set_minute(20)
		self._instance.set_ampm("AM")
		
		time_obj = self._instance.convert_to_time()
		
		self.assertEqual("1:20 AM", self._instance.get_time())
	
	def test_properties(self):
		hour = 1
		minute = 2
		ampm = "AM"
		filename = "blah.mp3"
		
		self._instance.set_hour(hour)
		self.assertEqual(hour, self._instance.get_hour())
		
		self._instance.set_minute(minute)
		self.assertEqual(minute, self._instance.get_minute())
		
		self._instance.set_ampm(ampm)
		self.assertEqual(ampm, self._instance.get_ampm())
		
		self._instance.set_audio_filename(filename)
		self.assertEqual(filename, self._instance.get_audio_filename())

if __name__ == '__main__':    
    unittest.main()
