# -*- Mode: Python; coding: utf-8; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 John Vrbanac <john.vrbanac (at) linux.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

"""Code to add AppIndicator."""

from gi.repository import Gtk  # pylint: disable=E0611
from gi.repository import AppIndicator3  # pylint: disable=E0611

from cuckoo_lib.helpers import get_media_file

import locale
from locale import gettext as _
locale.textdomain('cuckoo')


class Indicator:
    def __init__(self, window):
        self.indicator = AppIndicator3.Indicator.new('cuckoo', '', AppIndicator3.IndicatorCategory.APPLICATION_STATUS)
        self.indicator.set_status(AppIndicator3.IndicatorStatus.ACTIVE)
        self.indicator.set_title("Cuckoo")

        icon_uri = get_media_file("cuckoo.svg")
        icon_path = icon_uri.replace("file:///", '')
        self.indicator.set_icon(icon_path)

        #Uncomment and choose an icon for attention state.
        #self.indicator.set_attention_icon("ICON-NAME")

        self.menu = Gtk.Menu()

        self.show_menuitem = Gtk.MenuItem("Show/Hide")
        self.show_menuitem.connect("activate", window.on_mnu_show_activate)

        self.activate_menuitem = Gtk.MenuItem("Activate All")
        self.activate_menuitem.connect("activate", window.on_activate_all_items)
        self.deactivate_menuitem = Gtk.MenuItem("Deactivate All")
        self.deactivate_menuitem.connect("activate", window.on_deactivate_all_items)

        self.preferences_menuitem = Gtk.MenuItem("Preferences")
        self.preferences_menuitem.connect("activate", window.on_mnu_preferences_activate)

        self.quit_menuitem = Gtk.MenuItem("Quit")
        self.quit_menuitem.connect("activate", window.on_mnu_close_activate)

        self.menu.append(self.show_menuitem)
        self.menu.append(Gtk.SeparatorMenuItem())
        self.menu.append(self.activate_menuitem)
        self.menu.append(self.deactivate_menuitem)
        self.menu.append(Gtk.SeparatorMenuItem())
        self.menu.append(self.preferences_menuitem)
        self.menu.append(Gtk.SeparatorMenuItem())
        self.menu.append(self.quit_menuitem)

        self.menu.show_all()
        self.indicator.set_menu(self.menu)


def new_application_indicator(window):
    ind = Indicator(window)
    return ind.indicator
