# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 John Vrbanac <john.vrbanac (at) linux.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from cuckoo.CuckooConfigData import CuckooConfigData
from cuckoo_lib.helpers import get_media_file

import xdg.BaseDirectory
import ConfigParser
import os

"""
FIXME: Clean code smell (duplication) between CuckooConfig and CuckooAlarmList
Create a base class implementing core functionality for both classes.
"""


class CuckooConfig():
    __default_filename = "cuckoo.cfg"
    __alarm_inc = 0
    __config_folder = ""
    __config_path = ""
    __config_data = None
    __config = None

    def __init__(self):
        config_home = xdg.BaseDirectory.xdg_config_home

        self.__config = ConfigParser.ConfigParser()
        self.__config_folder = os.path.join(config_home, "cuckoo")
        self.__config_path = os.path.join(self.__config_folder, self.__default_filename)

        self.__config_data = CuckooConfigData()

        self.check_and_create()

    def read_general_section(self):
        alarmlist = self.__config.get("general", "last-used-alarm-list")
        volume = float(self.__config.get("general", "default-volume"))
        ring = self.__config.get("general", "default-media")

        # Added after the original version
        minimized = False
        if self.__config.has_option("general", "start-minimized"):
            minimized = self.__config.getboolean("general", "start-minimized")
        self.__config_data.set_start_minimized(minimized)
        
        self.__config_data.set_last_used_alarmlist(alarmlist)
        self.__config_data.set_default_volume(volume)
        self.__config_data.set_default_ring(ring)

    def write_general_section(self):
        self.__config.add_section("general")
        alarmlist = self.__config_data.get_last_used_alarmlist()
        volume = self.__config_data.get_default_volume()
        ring = self.__config_data.get_default_ring()
        minimized = self.__config_data.get_start_minimized()

        self.__config.set("general", "last-used-alarm-list", alarmlist)
        self.__config.set("general", "default-volume", str(volume))
        self.__config.set("general", "default-media", ring)
        self.__config.set("general", "start-minimized", minimized)

    def populate_defaults(self):
        default_alarm_file = os.path.join(self.__config_folder, "alarms.cfg")
        default_alarm_media = get_media_file("sounds/alarm.wav")

        self.__config_data.set_default_volume(1.4)
        self.__config_data.set_default_ring(default_alarm_media)
        self.__config_data.set_last_used_alarmlist(default_alarm_file)
        self.__config_data.set_start_minimized(False)
        self.write_general_section()
        self.save()

    def set_data(self, data):
        if not data == None:
            self.__config_data = data
        else:
            self.__config_data = CuckooConfigData()

    def get_data(self):
        return self.__config_data

    def check_and_create(self):
        if not os.path.exists(self.__config_folder):
            os.mkdir(self.__config_folder)

    def load(self):
        self.__config = ConfigParser.ConfigParser()
        if not os.path.exists(self.__config_path):
            self.populate_defaults()
        self.__config.read(self.__config_path)
        self.read_general_section()

    def save(self):
        self.__config = ConfigParser.ConfigParser()
        self.write_general_section()
        sfile = open(self.__config_path, "w")
        self.__config.write(sfile)
