# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 John Vrbanac <john.vrbanac (at) linux.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE
import locale

import time
import os
import random
from cuckoo_lib.helpers import get_media_file


class CuckooAlarmData():
    TIME_FORMAT = "%I:%M %p"
    _id = str(random.random())
    _hour = 0
    _minute = 0
    _ampm = ""
    _audio_filename = get_media_file("sounds/alarm.ogg")
    _volume = 1.4
    _activated = False
    _playing = False

    def populate_defaults(self):
        self.set_hour(8)
        self.set_minute(0)
        self.set_ampm("AM")

    def convert_to_time(self):
        # Temporary locale conversion for the time
        self.set_locale()

        tmp = str(self._hour) + ":" + str(self.get_minute())
        tmp += " " + self._ampm

        time_obj = time.strptime(tmp, self.TIME_FORMAT)

        # Resetting Locale
        self.set_locale(True)

        return time_obj

    def get_time(self):
        # Temporary locale conversion for the time
        self.set_locale()

        time_obj = self.convert_to_time()
        time_str = time.strftime(CuckooAlarmData.TIME_FORMAT, time_obj)

        # Resetting Locale
        self.set_locale(True)
        return time_str.lstrip('0')

    def set_from_time_str(self, time_str):
        # Temporary locale conversion for the time
        self.set_locale()

        time_obj = time.strptime(time_str, self.TIME_FORMAT)

        hour = time.strftime("%I", time_obj)
        self.set_hour(int(hour))

        minute = time.strftime("%M", time_obj)
        self.set_minute(int(minute))

        ampm = time.strftime("%p", time_obj)
        self.set_ampm(ampm)

        # Resetting Locale
        self.set_locale(True)

    # Allows temporary forced locale settings for time conversions
    def set_locale(self, reset=False):
        if reset:
            locale.setlocale(locale.LC_ALL, self.cur_locale)
        else:
            self.cur_locale = locale.setlocale(locale.LC_ALL, "")
            locale.setlocale(locale.LC_ALL, "en_US.utf8")

    """ Properties """
    def get_hour(self):
        return self._hour

    def set_hour(self, hour):
        if not self.time_range_check(hour, 12):
            raise Exception("Invalid Data")
        self._hour = int(hour)

    def get_minute(self):
        return self._minute

    def set_minute(self, minute):
        if not self.time_range_check(minute, 59):
            raise Exception("Invalid Data")
        self._minute = int(minute)

    def get_ampm(self):
        return self._ampm

    def set_ampm(self, ampm):
        if not (ampm != "AM" or ampm != "PM"):
            raise Exception("Invalid Data")
        self._ampm = ampm

    def get_audio_filename(self):
        return self._audio_filename

    def set_audio_filename(self, audio_filename):
        self._audio_filename = audio_filename

    def get_volume(self):
        return self._volume

    def set_volume(self, vol):
        self._volume = float(vol)

    def get_activated(self):
        return self._activated

    def set_activated(self, toggle):
        self._activated = bool(toggle)

    def get_playing(self):
        return self._playing

    def set_playing(self, toggle):
        self._playing = bool(toggle)

    """ Util """
    def time_range_check(self, value, max_value):
        result = True
        if value < 0 or value > max_value:
            reset = False

        return result
