# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Jorge Alda jorgealda115@gmail.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE
import os, sys
import glob
import gettext
from gettext import gettext as _
gettext.textdomain('alg3py')

sys.dont_write_bytecode = True

class plugin_container():
    name = 'Plugin name'
    descr = 'Plugin description'
    author = 'Your name here'
    def code(self, widget):
        print 'Hello, world!'

class plugins_manager():
    
    plugins = []
    names = []
    def get_directory(self):
        return os.path.dirname(os.path.realpath(__file__))

    def load(self):
        self.names = []
        pathname = self.get_directory()
        for script in glob.glob( os.path.join(pathname, '*.py')):
            if str(script) != os.path.join(pathname, '__init__.py'):
                if str(script) != os.path.join(pathname, 'manager.py') :
                    self.names = self.names + [script]

    def setup(self):
        self.plugins = []
        for script in self.names:
            try:
                basename = os.path.basename(script)
                module = basename.replace('.py', '')
                _temp = __import__(module, globals(), locals(), ['plugin_container'], -1)
                ins = _temp.plugin_container()
                self.plugins = self.plugins + [ins]
            except IOError, (ErrorNumber, ErrorMessage):
                print "Congratulation! you have managed to trip a #%d error" % ErrorNumber
                print ErrorMessage

    def __len__(self):
        return len(self.plugins)
