# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Jorge Alda jorgealda115@gmail.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE
from gi.repository import Gtk
from alg3py.Matrix import *
import gettext
from gettext import gettext as _
gettext.textdomain('alg3py')

def complex_round(z, dec):
    if z.imag == 0:
        return round(z.real, dec)
    else:
        return round(z.real, dec) + (round(z.imag, dec)) * (0+1j)


class Mat_GUI():
    def __init__(self, A):
        if not isinstance(A, Matrix):
            raise Alg3Exception(_("It must be a matrix"))
        self.entries = {}
        self.rows = A.rows
        self.columns = A.columns
        self.table = Gtk.Grid()
        self.mode = 'Read-only'
        self.matrix = A
        for c in range(0, self.columns):
            for r in range(0, self.rows):
                ent = Gtk.Label()
                text = str(complex_round(A[(r, c)], 7))
                ent.set_width_chars(len(text) + 5)
                ent.justify = 2
                ent.set_text(text)
                self.entries[(r, c)] = ent
                self.table.attach(self.entries[(r, c)], c, r, 1, 1)
    def read(self):
        if self.mode == 'Read-only':
            return self.matrix
        else:
            try:
                Mat = Matrix(self.rows, self.columns)
                for c in range(0, self.columns):
                    for r in range(0, self.rows):
                        Mat[(r, c)] = complex(self.entries[(r, c)].get_text())
                Mat.simplify()
                self.matrix = Mat
                return Mat
            except:
                raise Alg3Exception(_('Not a valid number'))
    def switch_mode(self):
        if self.mode == 'Read-only':
            self.mode = 'Edition'
            self.table.destroy()
            self.table = Gtk.Grid()
            self.entries = {}
            for c in range(0, self.columns):
                for r in range(0, self.rows):
                    ent = Gtk.Entry() 
                    text = str(self.matrix[(r, c)])
                    ent.set_width_chars(len(text) + 5)
                    ent.justify = 2
                    ent.set_text(text)
                    self.entries[(r, c)] = ent
                    self.table.attach(self.entries[(r, c)], c, r, 1, 1)
        else:
            self.matrix = self.read()
            self.table.destroy()
            self.table = Gtk.Grid()
            self.entries = {}
            self.mode = 'Read-only'
            for c in range(0, self.columns):
                for r in range(0, self.rows):
                    ent = Gtk.Label()
                    text = str(complex_round(self.matrix[(r, c)], 7))
                    ent.set_width_chars(len(text) + 5)
                    ent.justify = 2
                    ent.set_text(text)
                    self.entries[(r, c)] = ent
                    self.table.attach(self.entries[(r, c)], c, r, 1, 1)

class Vect_GUI():
    def __init__(self, A):
        if not isinstance(A, Vect):
            raise Alg3Exception(_('It must be a vector'))
        self.entries = {}
        self.dimension = A.dimension
        self.table = Gtk.Grid()
        self.mode = 'Read-only'
        self.Vect = A
        for d in range(0, self.dimension):
            ent = Gtk.Label()
            text = str(complex_round(self.Vect[d], 7))
            ent.set_width_chars(len(text) + 5)
            ent.justify = 2
            ent.set_text(text)
            self.entries[d] = ent
            self.table.attach(self.entries[d], d, 0, 1, 1)
    def read(self):
        if self.mode == 'Read-only':
            return self.Vect
        else:
            v = Vect(self.dimension)
            for d in range(0, self.dimension):
                v[d] = complex((self.entries[d]).get_text())
            v.simplify()
            return v
    def switch_mode(self):
        if self.mode == 'Read-only':
            self.mode = 'Edition'
            self.table.destroy()
            self.table = Gtk.Grid()
            for d in range(0, self.dimension):
                ent = Gtk.Entry()
                ent.set_text(str(self.Vect[d]))
                self.entries[d] = ent
                self.table.attach(self.entries[d], d, 0, 1, 1)
        else:
            self.Vect = self.read()
            self.mode = 'Read-only'
            self.table.destroy()
            self.table = Gtk.Grid()
            for d in range(0, self.dimension):
                ent = Gtk.Label()
                text = str(complex_round(self.Vect[d], 7))
                ent.set_width_chars(len(text) + 5)
                ent.justify = 2
                ent.set_text(text)
                self.entries[d] = ent
                self.table.attach(self.entries[d], d, 0, 1, 1)

class Scalar_GUI():
    def __init__(self, A):
        self.ent = Gtk.Label()
        text = str(complex_round(A, 7))
        self.ent.set_width_chars(len(text) + 5)
        self.ent.justify = 2
        self.ent.set_text(text)
        self.table = Gtk.Grid()
        self.table.attach(self.ent, 0, 0, 1, 1)
        self.mode = "Read-only"
        self.number = A
    def read(self):
        if self.mode == 'Edition':
            try:
                res = complex(self.ent.get_text())
                self.number = res
                if res.imag == 0:
                    return res.real
                else:
                    return res
            except:
                raise Alg3Exception (_('Not a valid number'))
        else:
            return self.number
    def switch_mode(self):
        if self.mode == "Read-only":
            self.mode = "Edition"
            self.table.destroy()
            self.table = Gtk.Grid()
            self.ent = Gtk.Entry()
            self.ent.set_text(str(self.number))
            self.table.attach(self.ent, 0, 0, 1, 1)
        else:
            self.number = self.read()
            self.mode = "Read-only"
            self.table.destroy()
            self.table = Gtk.Grid()
            self.ent = Gtk.Label()
            text = str(complex_round(self.number, 7))
            self.ent.set_width_chars(len(text) + 5)
            self.ent.justify = 2
            self.ent.set_text(text)
            self.table.attach(self.ent, 0, 0, 1, 1)

class Mat_GUI_w():
        def __init__(self, A):
                self.Mat = A
                self.window = Gtk.Window()
                self.window.set_title(_("Enter matrix"))
                self.create_widgets(A)
                self.connect_signals()
                self.window.show_all()
                Gtk.main()
        def create_widgets(self, A):
                self.vbox = Gtk.VBox(spacing = 10)
                self.table = Mat_GUI(A)
                self.button_ok = Gtk.Button("OK")
                self.button_exit = Gtk.Button("Exit")
                self.vbox.pack_start(self.table.table, True, True, 0)
                self.vbox.pack_start(self.button_ok, True, True, 0)
                self.vbox.pack_start(self.button_exit, True, True, 0)
                self.window.add(self.vbox)
        def connect_signals(self):
                self.button_ok.connect("clicked", self.callback_ok)
                self.button_exit.connect("clicked", self.callback_exit)
        def callback_ok(self, widget, callback_data = None):
                self.Mat = self.table.read()
        def callback_exit(self, widget, callback_data=None):
                Gtk.main_quit()
