# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Jorge Alda jorgealda115@gmail.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from gi.repository import Gtk # pylint: disable=E0611

from alg3py_lib.helpers import get_builder

import gettext
from gettext import gettext as _
gettext.textdomain('alg3py')
import quickly.widgets.dictionary_grid as DG

class AboutpluginsDialog(Gtk.Dialog):
    __gtype_name__ = "AboutpluginsDialog"

    def __new__(cls):
        """Special static method that's automatically called by Python when 
        constructing a new instance of this class.
        
        Returns a fully instantiated AboutpluginsDialog object.
        """
        builder = get_builder('AboutpluginsDialog')
        new_object = builder.get_object('aboutplugins_dialog')
        new_object.finish_initializing(builder)
        return new_object

    def finish_initializing(self, builder):
        """Called when we're finished initializing.

        finish_initalizing should be called after parsing the ui definition
        and creating a AboutpluginsDialog object with it in order to
        finish initializing the start of the new AboutpluginsDialog
        instance.
        """
        # Get a reference to the builder and set up the signals.
        self.builder = builder
        self.ui = builder.get_ui(self)

    def load_plugins_list(self, list_p):
        Dict = []
        for plugin in list_p:
            pl = {'Name':plugin.name, 'Author':plugin.author, 'Description':plugin.descr}
            Dict = Dict + [pl]
        self.Grid = DG.DictionaryGrid(dictionaries=Dict, keys=['Name'] )
        self.Grid.editable = False
        self.Grid.show()
        select = self.Grid.get_selection()
        select.set_mode(1)
        select.connect("changed", self.selected)
        select.unselect_all()
        (model, it) = select.get_selected()
        select.select_iter(model.get_iter_first())
        self.ui.grid1.attach(self.Grid, 0, 0, 1, 2)

    def on_btn_ok_clicked(self, widget, data=None):
        """The user has elected to save the changes.

        Called before the dialog returns Gtk.ResponseType.OK from run().
        """
        pass

    def on_btn_cancel_clicked(self, widget, data=None):
        """The user has elected cancel changes.

        Called before the dialog returns Gtk.ResponseType.CANCEL for run()
        """
        pass

    def selected(self, widget, data=None):
        if len(self.Grid.selected_rows) == 1:
            self.ui.lblAut.set_text(self.Grid.selected_rows[0]['Author'])
            self.ui.lblDescr.set_text(self.Grid.selected_rows[0]['Description'])

if __name__ == "__main__":
    dialog = AboutpluginsDialog()
    dialog.show()
    Gtk.main()
