
import sqlite3
import os
import gobject

class prefs(gobject.GObject):

	
	__gsignals__ = {
		'pref_changed' : (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, (gobject.TYPE_STRING, gobject.TYPE_INT,))
	}

	def __init__(self, db_path):
		gobject.GObject.__init__(self)
		self.home_path = os.getenv("HOME")
		self.db_path = db_path
		self.conn = sqlite3.connect(self.home_path + self.db_path)
		self.cursor = self.conn.cursor()

	def __del__(self):
		self.cursor.close()
		self.conn.close()

	def create_pref(self, name, value):
		self.cursor.execute("SELECT COUNT (*) FROM prefs WHERE prefname = ?", [name])
		row = self.cursor.fetchone()
		if row[0] == 0:
			self.cursor.execute("INSERT INTO prefs (prefname, prefvalue) VALUES (?, ?)", (name, value))

	def get_pref(self, name):
		self.cursor.execute("SELECT prefvalue FROM prefs WHERE prefname = ?", [name])
		row = self.cursor.fetchone()
		return row[0]

	def set_pref(self, name, value, sig = None):
		self.cursor.execute("UPDATE prefs SET prefvalue = ? WHERE prefname = ?", (value, name))
		if sig == True:
			self.emit('pref_changed', name, value)

	def flush(self):
		self.conn.commit()
