
import feedparser
import sqlite3
import socket
import os
import time
from threading import Thread

class feedreader(Thread):

	def __init__(self, feeduri, feedid, treerow, q, cache_days, db_path):
		Thread.__init__(self)
		self.feeduri = feeduri
		self.feedid = feedid
		self.treerow = treerow
		self.queue = q
		self.cache_days = cache_days
		self.status = 0
		self.parseduri = ""
		self.home_path = os.getenv("HOME")
		self.db_path = db_path

	def run(self):

		self.conn = sqlite3.connect(self.home_path + self.db_path)
		self.cursor = self.conn.cursor()

		timeout = 20
		socket.setdefaulttimeout(timeout)

		data = feedparser.parse(self.feeduri)
		if data.feed.has_key("title"):
			self.status = 1

			# clear old stuff and quick read stuff out of the items table
			now = int(time.time())
			old = now - (86400 * self.cache_days)
			self.conn.execute("DELETE FROM items WHERE readdate < ?", [str(old)])
			self.conn.execute("DELETE FROM items WHERE feedid = 0")

			# Feed title
			title = data.feed.title
			if len(title) == 0:
				title = "No feed title"

			# Feed description
			if data.feed.has_key("description"):
				desc = data.feed.description
			else:
				desc = "This feed doesn't have a description"
			if len(desc) == 0:
				desc = "This feed doesn't have a description"

			# Feed date
			if data.feed.has_key("published"):
        			date = data.feed.published
        		else:
        			date = ""

			# Feed link
        		if data.feed.has_key("link"):
        			link = data.feed.link
        		else:
        			link = ""

			# Add feed info to the database
			self.cursor.execute("SELECT COUNT (*) FROM items WHERE feedid = ? AND itemtype = 'title'", [self.feedid])
			row = self.cursor.fetchone()
			if row[0] == 0:
				self.cursor.execute("INSERT INTO items (feedid, itemtitle, itemsummary, itemdate, itemlink, enclink, itemtype, readdate) VALUES (?, ?, ?, ?, ?, '', 'title', ?)", (self.feedid, title, desc, date, link, now))
			else:
				self.cursor.execute("UPDATE items SET itemtitle = ?, itemsummary = ?, itemdate = ?, itemlink = ?, readdate = ? WHERE feedid = ? AND itemtype = 'title'", (title, desc, date, link, now, self.feedid))

			# Read the feed items
        		for i in range(len(data.entries)):

				# Item title
				if data.entries[i].has_key("title"):
					title = data.entries[i].title
				else:
					title = "No Item Title"
				if len(title) == 0:
					title = "No Item Title"

				# Item summary
				if data.entries[i].has_key("summary"):
					summary = data.entries[i].summary
				else:
					summary = "This feed item doesn't have a summary"
				if len(summary) == 0:
					summary = "This feed item doesn't have a summary"

				# Item date
				date = data.entries[i].updated

				# Item link
				if data.entries[i].has_key("link"):
					link = data.entries[i].link
				else:
					link = ""

				# Enclosure link
        			if len(data.entries[i].enclosures) > 0: # TODO: checking for enclosures needs to be a bit smarter to handle enclosures in Atom feeds
        				enc_link = data.entries[i].enclosures[0].href
        			else:
					enc_link = "";

				# Add feed item to the database
				self.cursor.execute("SELECT COUNT (*) FROM items WHERE feedid = ? AND itemlink = ?", (self.feedid, link))
				row = self.cursor.fetchone()
				if row[0] == 0:
					self.cursor.execute("INSERT INTO items (feedid, itemtitle, itemsummary, itemdate, itemlink, enclink, itemtype, readdate) VALUES (?, ?, ?, ?, ?, ?, 'item', ?)", (self.feedid, title, summary, date, link, enc_link, now))
			self.conn.commit()
		else:
			self.status = 2

		if self.status == 1:
			if self.feeduri != data.href and self.treerow != 0:
				self.parseduri = data.href

		self.cursor.close()
		self.conn.close()

		self.queue.put([self.status, self.feedid, self.treerow, self.parseduri])
