# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Mike Kroger <mikek01@telkomsa.net>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

# This is your preferences dialog.
#
# Define your preferences dictionary in the __init__.main() function.
# The widget names in the PreferencesTestProjectDialog.ui
# file need to correspond to the keys in the preferences dictionary.
#
# Each preference also need to be defined in the 'widget_methods' map below
# to show up in the dialog itself.  Provide three bits of information:
#  1) The first entry is the method on the widget that grabs a value from the
#     widget.
#  2) The second entry is the method on the widget that sets the widgets value
#      from a stored preference.
#  3) The third entry is a signal the widget will send when the contents have
#     been changed by the user. The preferences dictionary is always up to
# date and will signal the rest of the application about these changes.
# The values will be saved to desktopcouch when the application closes.
#
# TODO: replace widget_methods with your own values


widget_methods = {
    'show_tree_lines_cb': ['get_active', 'set_active', 'toggled', 'enable_tree_lines'],
    'feed_tree_hint_cb': ['get_active', 'set_active', 'toggled', 'feed_tree_hint'],
    'item_list_hint_cb': ['get_active', 'set_active', 'toggled', 'item_list_hint'],
    'show_summary_cb': ['get_active', 'set_active', 'toggled', 'show_summary_pane'],
    'ft_font_adjustment': ['get_value', 'set_value', 'value_changed', 'feed_tree_font_size'],
    'il_font_adjustment': ['get_value', 'set_value', 'value_changed', 'item_list_font_size'],
    'mark_enc_and_item_cb': ['get_active', 'set_active', 'toggled', 'mark_enc_and_item'],
    'cache_days_adjustment': ['get_value', 'set_value', 'value_changed', 'cache_days'],
}


import gettext
from gettext import gettext as _
gettext.textdomain('wizzrss')

from wizzrss_lib.PreferencesDialog import PreferencesDialog

class PreferencesWizzrssDialog(PreferencesDialog):
    __gtype_name__ = "PreferencesWizzrssDialog"

    def finish_initializing(self, builder): # pylint: disable=E1002
        """Set up the preferences dialog"""
        super(PreferencesWizzrssDialog, self).finish_initializing(builder)

        # populate the dialog from the preferences dictionary
        # using the methods from widget_methods
        #self.widget_methods = widget_methods
        #self.set_widgets_from_preferences() # pylint: disable=E1101

        # Code for other initialization actions should be added here.

    def set_pref_ref(self, prefs):
        self.prefs = prefs

    def set_widgets(self):
        for key in widget_methods:
            value = self.prefs.get_pref(widget_methods[key][3])
            widget = self.builder.get_object(key)
            write_method_name = widget_methods[key][1]
            method = getattr(widget, write_method_name)
            method(int(value))
            widget.connect(widget_methods[key][2], self.set_preference, key)

    def set_preference(self, widget, data = None):
        key = data
        read_method_name = widget_methods[key][0]
        read_method = getattr(widget, read_method_name)
        value = int(read_method())
        self.prefs.set_pref(widget_methods[key][3], value, True)
        self.prefs.flush()

