# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Nathan Seal nathan@nathanseal.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import time
import wiimote
import virtualinput
import re
from mapper.mapper import Mapper
import math
import wiimoteHandler
import wiimote

class WiiMap(wiimoteHandler.WiimoteHandler):
	"""
	class for mapping wiimote input to keyboard, mouse and joystick input.
	"""
	mappings = Mapper()
	booleanKeys = {}
	vinput = None
	nosave = False
	def __init__(self):
		self.vinput = virtualinput.VirtualInputX11()
	
	def onButtonDown(self, wm, button):
		wm = wm + 1
		bstring = wiimote.buttonNumber_to_buttonString(button)
		print bstring, "DOWN"
		self.handleActions('wiimote.' + str(wm) + '.' + bstring, True)
		self.handleActions('wiimote.' + bstring, True)
	
	def onButtonUp(self, wm, button):
		wm = wm + 1
		bstring = wiimote.buttonNumber_to_buttonString(button)
		print bstring, "UP"
		self.handleActions('wiimote.' + str(wm) + '.' + bstring, False)
		self.handleActions('wiimote.' + bstring, False)
	
	def onAccChange(self, wm, acc, xac, yac, zac, xax, yax, zax):
	    #print '{0:1d} {1:5d} {2:5d} {3:5d} {4:5d} {5:5d} {6:5d} {7:5d}'.format(wm, int(acc), int(xac), int(yac), int(zac), int(xax), int(yax), int(zax))
	    #print wm, acc, xac, yac, zac, xax, yax, zax
		wm = wm + 1
		self.handleActions('wiimote.' + str(wm) + '.acc', acc)
		self.handleActions('wiimote.' + str(wm) + '.xac', acc)
		self.handleActions('wiimote.' + str(wm) + '.yac', xac)
		self.handleActions('wiimote.' + str(wm) + '.zac', yac)
		self.handleActions('wiimote.' + str(wm) + '.xax', xax)
		self.handleActions('wiimote.' + str(wm) + '.yax', yax)
		self.handleActions('wiimote.' + str(wm) + '.zax', zax)
		self.handleActions('wiimote.acc', acc)
		self.handleActions('wiimote.xac', acc)
		self.handleActions('wiimote.yac', xac)
		self.handleActions('wiimote.yac', yac)
		self.handleActions('wiimote.xax', xax)
		self.handleActions('wiimote.yax', yax)
		self.handleActions('wiimote.zax', zax)
	def onIRChange(self, wm, x, y):
		#print 'IR:', x, y
		wm = wm + 1
		self.handleActions('wiimote.' + str(wm) + '.irx', x)
		self.handleActions('wiimote.' + str(wm) + '.iry', y)
		self.handleActions('wiimote.irx', x)
		self.handleActions('wiimote.iry', y)
	
	def handleActions(self, froom, value):
		actions = self.mappings.getMapping(froom)
		for action, params in actions:
			action(value, **params)
	
	def keyboardHandle(self, key, down):
		print "ACTION KEY" , key, down
		if down:
			self.vinput.keyPress(key)
		else:
			self.vinput.keyRelease(key)
	
	def mouseButtonHandle(self, button, down):
		if down:
			self.vinput.buttonPress(button)
		else:
			self.vinput.buttonRelease(button)
	def mouseMoveHandle(self, value, xy):
		#print "mouseMoveHandle", value, xy
		x = None
		y = None
		if xy == 'x':
			x = value
		elif xy == 'y':
			y = value
		self.vinput.moveMouse(x,y)
	   
	def booleanHandle(self, down, fullcode, func, key):
		if fullcode not in self.booleanKeys:
			self.booleanKeys[fullcode] = not down
		if self.booleanKeys[fullcode] != down:
			func(key, down)
			self.booleanKeys[fullcode] = down
	
	def linearHandle(self, value, fullcode, func, key):
		func(value, key)
	
	def booleanBooleanHandle(self, down, fullcode, invert, func, key, **x):
		if invert:
			down = not down
		self.booleanHandle(down, fullcode, func, key)
	
	def linearBooleanHandle(self, value, low, high, invert, fullcode, func, key, **x):
		down = False
		if low <= high and value >= low and value <= high:
			down = True
		if low > high and (value >= low or value <= high):
			down = True
		if invert:
			down = not down
		self.booleanHandle(down, fullcode, func, key)
	
	def linearLinearHandle(self, value, flow, fhigh, tlow, thigh, fullcode, func, key, **x):
		print "linearLinearHandle"
		value = min(max(value, flow), fhigh)
		ratio = (value - flow) / (fhigh - flow)
		
		value = tlow + (thigh - tlow) * ratio
		
		self.linearHandle(value, fullcode, func, key)
				
	
	
	def saveMappingToFile(self, fileName):
	    if not self.nosave:
		    with open(fileName, 'w') as fp:
			    for froom, to in self.mappings.mappings.iteritems():
				    fp.write(froom + ' {\n')
				    print `to`
				    for f, part in to:
					    if 'fullcode' in part:
						    fp.write('\t' + part['fullcode'])
						    for param in part['params']:
						        fp.write(' ' + param)
						    fp.write(';\n')
				    fp.write('}\n')
		        fp.close()
	
	def newMapping(self):
		self.mappings.clearMappings()
	
	def setMappingsFromFile(self, fileName):
		text = open(fileName).read()
		if re.match(r'^&NOSAVE&', text):
		    self.nosave = True
		    text = re.sub(r'^&NOSAVE&', '', text)
		else:
		    self.nosave = False
		
		#remove comments
		text = re.sub(r'/\*.*?\*/', '', text)
		
		pattern = r'\s*(?P<mapfrom>[a-z_A-Z.0-9]+)\s*\{\s*(?P<mapTo>[\sa-z_A-Z.0-9;]*)\}'
		
		for match in re.finditer(pattern, text):
			froom = match.group('mapfrom')
			toList = match.group('mapTo')
			self.setMappingFromString(froom, toList)
	
	def setMappingFromString(self, froom, toString):
	    self.mappings.clearMapping(froom)
		pattern = r'(?P<mapTo>[\sa-z_A-Z.0-9]*);'
		for match in re.finditer(pattern, toString):
			split = match.group('mapTo').split()
			to = split[0]
			params = []
			for part in split[1:]:
				params.append(part)
			self.addMapping(froom, to, params)
			print `self.mappings.mappings`
		
	def none(self, *args):
		print "none"
	def getHandle(self, froom, to):
		result = self.none
		if froom == "boolean":
			if to == "boolean":
				result = self.booleanBooleanHandle
		elif froom == "linear":
			if to == "boolean":
				result = self.linearBooleanHandle
			elif to == "linear":
				result = self.linearLinearHandle
		return result
	def addRequiredMote(self, mote):
		if mote not in self.requiredMotes:
			self.requiredMotes.append(mote)
	
	def addMapping(self, froom, to, params):
		fromType = ""
		toType = ""
		tosplit = to.split('.')
		fromsplit = froom.split('.')
		handleParams = {}
		validMap = False
		if len(fromsplit) > 0 and fromsplit[0] == 'wiimote':
			if fromsplit[1] in ['1', '2', '3', '4']:
				self.addRequiredMote(fromsplit[1])
				fromsplit.pop(1)
			if fromsplit[1] in ['xac','yac','zac']:
				fromType = "linear"
				handleParams['low'] = float(params[0]) if len(params) > 0 else -100
				handleParams['high'] = float(params[1]) if len(params) > 0 else 100
			elif fromsplit[1] in ['xax','yax','zax']:
				fromType = "linear"
				handleParams['low'] = float(params[0]) if len(params) > 0 else 0
				handleParams['high'] = float(params[1]) if len(params) > 0 else 360
			elif fromsplit[1] == 'acc':
				fromType = "linear"
				handleParams['low'] = float(params[0]) if len(params) > 0 else 0
				handleParams['high'] = float(params[1]) if len(params) > 0 else 100
			elif fromsplit[1] in ['irx','iry']:
				fromType = "linear"
			else:
				fromType = "boolean"
		if len(tosplit):
		    if tosplit[0] == 'keyboard':
		        if len(tosplit) == 2:
			        toType = "boolean"
			        if self.vinput.isValidKey(tosplit[1]):
			            handleParams['key'] = tosplit[1]
			            handleParams['invert'] = 'invert' in params
			            handleParams['func'] = self.keyboardHandle
			            validMap = True
		    if tosplit[0] == 'mouse':
			    if tosplit[1] in ['x', 'y']:
				    toType = "linear"
				    handleParams['key'] = tosplit[1]
				    handleParams['func'] = self.mouseMoveHandle
				    handleParams['flow'] = float(params[0]) if len(params) > 0 else 0
				    handleParams['fhigh'] = float(params[1]) if len(params) > 1 else 100
				    handleParams['tlow'] = float(params[2]) if len(params) > 2 else 0
				    handleParams['thigh'] = float(params[3]) if len(params) > 3 else 100
				    validMap = True
			    elif self.vinput.isValidButton(tosplit[1]):
			        if len(tosplit) == 2:
				        toType = "boolean"
				        handleParams['key'] = tosplit[1]
				        handleParams['invert'] = 'invert' in params
				        handleParams['func'] = self.mouseButtonHandle
				        validMap = True
		if validMap:
		    handleParams['fullcode'] = to
		    handleParams['params'] = params
		    handle = self.getHandle(fromType, toType)
		    self.mappings.addMapping(froom, (handle, handleParams))
	

if __name__ == "__main__":
	mapper = WiiMap()
	#mapper.setMappingsFromFile("sampleMap.wmap")
	#requiredMotes = len(mapper.requiredMotes)
	#mapper.onButtonDown(0, 1)
	#mapper.onButtonUp(0, 1)
	#print `mapper.mappings.mappings`
	#mapper.onButtonDown(wiimote.BTN_B)
	#mapper.onButtonUp(wiimote.BTN_B)
	mapper.start()
	while True:
		time.sleep(10)
	mapper.stop()
